/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.gson;

import com.contrastsecurity.thirdparty.com.google.gson.FieldNamingStrategy;
import java.lang.reflect.Field;
import java.util.Locale;

public enum FieldNamingPolicy implements FieldNamingStrategy
{
    IDENTITY{

        @Override
        public String translateName(Field field) {
            return field.getName();
        }
    }
    ,
    UPPER_CAMEL_CASE{

        @Override
        public String translateName(Field field) {
            return 2.upperCaseFirstLetter(field.getName());
        }
    }
    ,
    UPPER_CAMEL_CASE_WITH_SPACES{

        @Override
        public String translateName(Field field) {
            return 3.upperCaseFirstLetter(3.separateCamelCase(field.getName(), " "));
        }
    }
    ,
    LOWER_CASE_WITH_UNDERSCORES{

        @Override
        public String translateName(Field field) {
            return 4.separateCamelCase(field.getName(), "_").toLowerCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_DASHES{

        @Override
        public String translateName(Field field) {
            return 5.separateCamelCase(field.getName(), "-").toLowerCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_DOTS{

        @Override
        public String translateName(Field field) {
            return 6.separateCamelCase(field.getName(), ".").toLowerCase(Locale.ENGLISH);
        }
    };


    static String separateCamelCase(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isUpperCase(c2) && stringBuilder.length() != 0) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    static String upperCaseFirstLetter(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        char c2 = string.charAt(n2);
        int n3 = string.length();
        while (n2 < n3 - 1 && !Character.isLetter(c2)) {
            stringBuilder.append(c2);
            c2 = string.charAt(++n2);
        }
        if (!Character.isUpperCase(c2)) {
            String string2 = FieldNamingPolicy.modifyString(Character.toUpperCase(c2), string, ++n2);
            return stringBuilder.append(string2).toString();
        }
        return string;
    }

    private static String modifyString(char c2, String string, int n2) {
        return n2 < string.length() ? c2 + string.substring(n2) : String.valueOf(c2);
    }
}

