/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.googlecode.concurrentlinkedhashmap;

import com.contrastsecurity.thirdparty.com.googlecode.concurrentlinkedhashmap.EntryWeigher;
import com.contrastsecurity.thirdparty.com.googlecode.concurrentlinkedhashmap.EvictionListener;
import com.contrastsecurity.thirdparty.com.googlecode.concurrentlinkedhashmap.Linked;
import com.contrastsecurity.thirdparty.com.googlecode.concurrentlinkedhashmap.LinkedDeque;
import com.contrastsecurity.thirdparty.com.googlecode.concurrentlinkedhashmap.Weigher;
import com.contrastsecurity.thirdparty.com.googlecode.concurrentlinkedhashmap.Weighers;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ConcurrentLinkedHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final long MAXIMUM_CAPACITY = 9223372034707292160L;
    static final int NUMBER_OF_READ_BUFFERS = ConcurrentLinkedHashMap.ceilingNextPowerOfTwo(NCPU);
    static final int READ_BUFFERS_MASK = NUMBER_OF_READ_BUFFERS - 1;
    static final int READ_BUFFER_THRESHOLD = 32;
    static final int READ_BUFFER_DRAIN_THRESHOLD = 64;
    static final int READ_BUFFER_SIZE = 128;
    static final int READ_BUFFER_INDEX_MASK = 127;
    static final int WRITE_BUFFER_DRAIN_THRESHOLD = 16;
    static final Queue<?> DISCARDING_QUEUE = new DiscardingQueue();
    final ConcurrentMap<K, Node<K, V>> data;
    final int concurrencyLevel;
    @GuardedBy(value="evictionLock")
    final long[] readBufferReadCount;
    @GuardedBy(value="evictionLock")
    final LinkedDeque<Node<K, V>> evictionDeque;
    @GuardedBy(value="evictionLock")
    final AtomicLong weightedSize;
    @GuardedBy(value="evictionLock")
    final AtomicLong capacity;
    final Lock evictionLock;
    final Queue<Runnable> writeBuffer;
    final AtomicLong[] readBufferWriteCount;
    final AtomicLong[] readBufferDrainAtWriteCount;
    final AtomicReference<Node<K, V>>[][] readBuffers;
    final AtomicReference<DrainStatus> drainStatus;
    final EntryWeigher<? super K, ? super V> weigher;
    final Queue<Node<K, V>> pendingNotifications;
    final EvictionListener<K, V> listener;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;
    static final long serialVersionUID = 1L;

    static int ceilingNextPowerOfTwo(int n2) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
    }

    private ConcurrentLinkedHashMap(Builder<K, V> builder) {
        this.concurrencyLevel = builder.concurrencyLevel;
        this.capacity = new AtomicLong(Math.min(builder.capacity, 9223372034707292160L));
        this.data = new ConcurrentHashMap<K, Node<K, V>>(builder.initialCapacity, 0.75f, this.concurrencyLevel);
        this.weigher = builder.weigher;
        this.evictionLock = new ReentrantLock();
        this.weightedSize = new AtomicLong();
        this.evictionDeque = new LinkedDeque();
        this.writeBuffer = new ConcurrentLinkedQueue<Runnable>();
        this.drainStatus = new AtomicReference<DrainStatus>(DrainStatus.IDLE);
        this.readBufferReadCount = new long[NUMBER_OF_READ_BUFFERS];
        this.readBufferWriteCount = new AtomicLong[NUMBER_OF_READ_BUFFERS];
        this.readBufferDrainAtWriteCount = new AtomicLong[NUMBER_OF_READ_BUFFERS];
        this.readBuffers = new AtomicReference[NUMBER_OF_READ_BUFFERS][128];
        for (int i2 = 0; i2 < NUMBER_OF_READ_BUFFERS; ++i2) {
            this.readBufferWriteCount[i2] = new AtomicLong();
            this.readBufferDrainAtWriteCount[i2] = new AtomicLong();
            this.readBuffers[i2] = new AtomicReference[128];
            for (int i3 = 0; i3 < 128; ++i3) {
                this.readBuffers[i2][i3] = new AtomicReference();
            }
        }
        this.listener = builder.listener;
        this.pendingNotifications = this.listener == DiscardingListener.INSTANCE ? DISCARDING_QUEUE : new ConcurrentLinkedQueue();
    }

    static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    static void checkArgument(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    static void checkState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public long capacity() {
        return this.capacity.get();
    }

    public void setCapacity(long l2) {
        ConcurrentLinkedHashMap.checkArgument(l2 >= 0L);
        this.evictionLock.lock();
        try {
            this.capacity.lazySet(Math.min(l2, 9223372034707292160L));
            this.drainBuffers();
            this.evict();
        }
        finally {
            this.evictionLock.unlock();
        }
        this.notifyListener();
    }

    @GuardedBy(value="evictionLock")
    boolean hasOverflowed() {
        return this.weightedSize.get() > this.capacity.get();
    }

    @GuardedBy(value="evictionLock")
    void evict() {
        while (this.hasOverflowed()) {
            Node node = (Node)this.evictionDeque.poll();
            if (node == null) {
                return;
            }
            if (this.data.remove(node.key, node)) {
                this.pendingNotifications.add(node);
            }
            this.makeDead(node);
        }
    }

    void afterRead(Node<K, V> node) {
        int n2 = ConcurrentLinkedHashMap.readBufferIndex();
        long l2 = this.recordRead(n2, node);
        this.drainOnReadIfNeeded(n2, l2);
        this.notifyListener();
    }

    static int readBufferIndex() {
        return (int)Thread.currentThread().getId() & READ_BUFFERS_MASK;
    }

    long recordRead(int n2, Node<K, V> node) {
        AtomicLong atomicLong = this.readBufferWriteCount[n2];
        long l2 = atomicLong.get();
        atomicLong.lazySet(l2 + 1L);
        int n3 = (int)(l2 & 0x7FL);
        this.readBuffers[n2][n3].lazySet(node);
        return l2;
    }

    void drainOnReadIfNeeded(int n2, long l2) {
        long l3 = l2 - this.readBufferDrainAtWriteCount[n2].get();
        boolean bl = l3 < 32L;
        DrainStatus drainStatus = this.drainStatus.get();
        if (drainStatus.shouldDrainBuffers(bl)) {
            this.tryToDrainBuffers();
        }
    }

    void afterWrite(Runnable runnable) {
        this.writeBuffer.add(runnable);
        this.drainStatus.lazySet(DrainStatus.REQUIRED);
        this.tryToDrainBuffers();
        this.notifyListener();
    }

    void tryToDrainBuffers() {
        if (this.evictionLock.tryLock()) {
            try {
                this.drainStatus.lazySet(DrainStatus.PROCESSING);
                this.drainBuffers();
            }
            finally {
                this.drainStatus.compareAndSet(DrainStatus.PROCESSING, DrainStatus.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    @GuardedBy(value="evictionLock")
    void drainBuffers() {
        this.drainReadBuffers();
        this.drainWriteBuffer();
    }

    @GuardedBy(value="evictionLock")
    void drainReadBuffers() {
        int n2 = (int)Thread.currentThread().getId();
        int n3 = n2 + NUMBER_OF_READ_BUFFERS;
        for (int i2 = n2; i2 < n3; ++i2) {
            this.drainReadBuffer(i2 & READ_BUFFERS_MASK);
        }
    }

    @GuardedBy(value="evictionLock")
    void drainReadBuffer(int n2) {
        int n3;
        AtomicReference<Node<K, V>> atomicReference;
        Node<K, V> node;
        long l2 = this.readBufferWriteCount[n2].get();
        for (int i2 = 0; i2 < 64 && (node = (atomicReference = this.readBuffers[n2][n3 = (int)(this.readBufferReadCount[n2] & 0x7FL)]).get()) != null; ++i2) {
            atomicReference.lazySet(null);
            this.applyRead(node);
            int n4 = n2;
            this.readBufferReadCount[n4] = this.readBufferReadCount[n4] + 1L;
        }
        this.readBufferDrainAtWriteCount[n2].lazySet(l2);
    }

    @GuardedBy(value="evictionLock")
    void applyRead(Node<K, V> node) {
        if (this.evictionDeque.contains(node)) {
            this.evictionDeque.moveToBack(node);
        }
    }

    @GuardedBy(value="evictionLock")
    void drainWriteBuffer() {
        Runnable runnable;
        for (int i2 = 0; i2 < 16 && (runnable = this.writeBuffer.poll()) != null; ++i2) {
            runnable.run();
        }
    }

    boolean tryToRetire(Node<K, V> node, WeightedValue<V> weightedValue) {
        if (weightedValue.isAlive()) {
            WeightedValue weightedValue2 = new WeightedValue(weightedValue.value, -weightedValue.weight);
            return node.compareAndSet(weightedValue, weightedValue2);
        }
        return false;
    }

    void makeRetired(Node<K, V> node) {
        WeightedValue weightedValue;
        WeightedValue weightedValue2;
        do {
            if ((weightedValue2 = (WeightedValue)node.get()).isAlive()) continue;
            return;
        } while (!node.compareAndSet(weightedValue2, weightedValue = new WeightedValue(weightedValue2.value, -weightedValue2.weight)));
    }

    @GuardedBy(value="evictionLock")
    void makeDead(Node<K, V> node) {
        WeightedValue weightedValue;
        WeightedValue weightedValue2;
        while (!node.compareAndSet(weightedValue2 = (WeightedValue)node.get(), weightedValue = new WeightedValue(weightedValue2.value, 0))) {
        }
        this.weightedSize.lazySet(this.weightedSize.get() - (long)Math.abs(weightedValue2.weight));
    }

    void notifyListener() {
        Node<K, V> node;
        while ((node = this.pendingNotifications.poll()) != null) {
            this.listener.onEviction(node.key, node.getValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public long weightedSize() {
        return Math.max(0L, this.weightedSize.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.evictionLock.lock();
        try {
            Node node;
            while ((node = (Node)this.evictionDeque.poll()) != null) {
                this.data.remove(node.key, node);
                this.makeDead(node);
            }
            Object object = this.readBuffers;
            int n2 = ((AtomicReference<Node<K, V>>[][])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                AtomicReference<Node<K, V>>[] atomicReferenceArray;
                for (AtomicReference<Node<K, Object>> atomicReference : atomicReferenceArray = object[i2]) {
                    atomicReference.lazySet(null);
                }
            }
            while ((object = this.writeBuffer.poll()) != null) {
                object.run();
            }
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return this.data.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        ConcurrentLinkedHashMap.checkNotNull(object);
        for (Node node : this.data.values()) {
            if (!node.getValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        Node node = (Node)this.data.get(object);
        if (node == null) {
            return null;
        }
        this.afterRead(node);
        return node.getValue();
    }

    public V getQuietly(Object object) {
        Node node = (Node)this.data.get(object);
        return node == null ? null : (V)node.getValue();
    }

    @Override
    public V put(K k2, V v2) {
        return this.put(k2, v2, false);
    }

    @Override
    public V putIfAbsent(K k2, V v2) {
        return this.put(k2, v2, true);
    }

    V put(K k2, V v2, boolean bl) {
        WeightedValue weightedValue;
        Node<K, WeightedValue<V>> node;
        ConcurrentLinkedHashMap.checkNotNull(k2);
        ConcurrentLinkedHashMap.checkNotNull(v2);
        int n2 = this.weigher.weightOf(k2, v2);
        WeightedValue<V> weightedValue2 = new WeightedValue<V>(v2, n2);
        Node<K, V> node2 = new Node<K, V>(k2, weightedValue2);
        block0: while (true) {
            if ((node = this.data.putIfAbsent(node2.key, node2)) == null) {
                this.afterWrite(new AddTask(node2, n2));
                return null;
            }
            if (bl) {
                this.afterRead(node);
                return node.getValue();
            }
            do {
                if (!(weightedValue = (WeightedValue)node.get()).isAlive()) continue block0;
            } while (!node.compareAndSet(weightedValue, weightedValue2));
            break;
        }
        int n3 = n2 - weightedValue.weight;
        if (n3 == 0) {
            this.afterRead(node);
        } else {
            this.afterWrite(new UpdateTask(node, n3));
        }
        return weightedValue.value;
    }

    @Override
    public V remove(Object object) {
        Node node = (Node)this.data.remove(object);
        if (node == null) {
            return null;
        }
        this.makeRetired(node);
        this.afterWrite(new RemovalTask(node));
        return node.getValue();
    }

    @Override
    public boolean remove(Object object, Object object2) {
        Node node = (Node)this.data.get(object);
        if (node == null || object2 == null) {
            return false;
        }
        WeightedValue weightedValue = (WeightedValue)node.get();
        while (weightedValue.contains(object2)) {
            if (this.tryToRetire(node, weightedValue)) {
                if (!this.data.remove(object, node)) break;
                this.afterWrite(new RemovalTask(node));
                return true;
            }
            weightedValue = (WeightedValue)node.get();
            if (weightedValue.isAlive()) continue;
        }
        return false;
    }

    @Override
    public V replace(K k2, V v2) {
        WeightedValue weightedValue;
        ConcurrentLinkedHashMap.checkNotNull(k2);
        ConcurrentLinkedHashMap.checkNotNull(v2);
        int n2 = this.weigher.weightOf(k2, v2);
        WeightedValue<V> weightedValue2 = new WeightedValue<V>(v2, n2);
        Node node = (Node)this.data.get(k2);
        if (node == null) {
            return null;
        }
        do {
            if ((weightedValue = (WeightedValue)node.get()).isAlive()) continue;
            return null;
        } while (!node.compareAndSet(weightedValue, weightedValue2));
        int n3 = n2 - weightedValue.weight;
        if (n3 == 0) {
            this.afterRead(node);
        } else {
            this.afterWrite(new UpdateTask(node, n3));
        }
        return weightedValue.value;
    }

    @Override
    public boolean replace(K k2, V v2, V v3) {
        WeightedValue weightedValue;
        ConcurrentLinkedHashMap.checkNotNull(k2);
        ConcurrentLinkedHashMap.checkNotNull(v2);
        ConcurrentLinkedHashMap.checkNotNull(v3);
        int n2 = this.weigher.weightOf(k2, v3);
        WeightedValue<V> weightedValue2 = new WeightedValue<V>(v3, n2);
        Node node = (Node)this.data.get(k2);
        if (node == null) {
            return false;
        }
        do {
            if ((weightedValue = (WeightedValue)node.get()).isAlive() && weightedValue.contains(v2)) continue;
            return false;
        } while (!node.compareAndSet(weightedValue, weightedValue2));
        int n3 = n2 - weightedValue.weight;
        if (n3 == 0) {
            this.afterRead(node);
        } else {
            this.afterWrite(new UpdateTask(node, n3));
        }
        return true;
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet == null ? (this.keySet = new KeySet()) : keySet;
    }

    public Set<K> ascendingKeySet() {
        return this.ascendingKeySetWithLimit(Integer.MAX_VALUE);
    }

    public Set<K> ascendingKeySetWithLimit(int n2) {
        return this.orderedKeySet(true, n2);
    }

    public Set<K> descendingKeySet() {
        return this.descendingKeySetWithLimit(Integer.MAX_VALUE);
    }

    public Set<K> descendingKeySetWithLimit(int n2) {
        return this.orderedKeySet(false, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<K> orderedKeySet(boolean bl, int n2) {
        ConcurrentLinkedHashMap.checkArgument(n2 >= 0);
        this.evictionLock.lock();
        try {
            Iterator<Node<K, V>> iterator;
            this.drainBuffers();
            int n3 = this.weigher == Weighers.entrySingleton() ? Math.min(n2, (int)this.weightedSize()) : 16;
            LinkedHashSet linkedHashSet = new LinkedHashSet(n3);
            Iterator<Node<K, V>> iterator2 = iterator = bl ? this.evictionDeque.iterator() : this.evictionDeque.descendingIterator();
            while (iterator.hasNext() && n2 > linkedHashSet.size()) {
                linkedHashSet.add(iterator.next().key);
            }
            Set set = Collections.unmodifiableSet(linkedHashSet);
            return set;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values == null ? (this.values = new Values()) : values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet == null ? (this.entrySet = new EntrySet()) : entrySet;
    }

    public Map<K, V> ascendingMap() {
        return this.ascendingMapWithLimit(Integer.MAX_VALUE);
    }

    public Map<K, V> ascendingMapWithLimit(int n2) {
        return this.orderedMap(true, n2);
    }

    public Map<K, V> descendingMap() {
        return this.descendingMapWithLimit(Integer.MAX_VALUE);
    }

    public Map<K, V> descendingMapWithLimit(int n2) {
        return this.orderedMap(false, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<K, V> orderedMap(boolean bl, int n2) {
        ConcurrentLinkedHashMap.checkArgument(n2 >= 0);
        this.evictionLock.lock();
        try {
            Object object;
            Iterator<Node<K, V>> iterator;
            this.drainBuffers();
            int n3 = this.weigher == Weighers.entrySingleton() ? Math.min(n2, (int)this.weightedSize()) : 16;
            LinkedHashMap linkedHashMap = new LinkedHashMap(n3);
            Iterator<Node<K, V>> iterator2 = iterator = bl ? this.evictionDeque.iterator() : this.evictionDeque.descendingIterator();
            while (iterator.hasNext() && n2 > linkedHashMap.size()) {
                object = iterator.next();
                linkedHashMap.put(((Node)object).key, ((Node)object).getValue());
            }
            object = Collections.unmodifiableMap(linkedHashMap);
            return object;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public static final class Builder<K, V> {
        static final int DEFAULT_CONCURRENCY_LEVEL = 16;
        static final int DEFAULT_INITIAL_CAPACITY = 16;
        EvictionListener<K, V> listener;
        EntryWeigher<? super K, ? super V> weigher = Weighers.entrySingleton();
        int concurrencyLevel = 16;
        int initialCapacity = 16;
        long capacity = -1L;

        public Builder() {
            this.listener = DiscardingListener.INSTANCE;
        }

        public Builder<K, V> initialCapacity(int n2) {
            ConcurrentLinkedHashMap.checkArgument(n2 >= 0);
            this.initialCapacity = n2;
            return this;
        }

        public Builder<K, V> maximumWeightedCapacity(long l2) {
            ConcurrentLinkedHashMap.checkArgument(l2 >= 0L);
            this.capacity = l2;
            return this;
        }

        public Builder<K, V> concurrencyLevel(int n2) {
            ConcurrentLinkedHashMap.checkArgument(n2 > 0);
            this.concurrencyLevel = n2;
            return this;
        }

        public Builder<K, V> listener(EvictionListener<K, V> evictionListener) {
            ConcurrentLinkedHashMap.checkNotNull(evictionListener);
            this.listener = evictionListener;
            return this;
        }

        public Builder<K, V> weigher(Weigher<? super V> weigher) {
            this.weigher = weigher == Weighers.singleton() ? Weighers.entrySingleton() : new BoundedEntryWeigher(Weighers.asEntryWeigher(weigher));
            return this;
        }

        public Builder<K, V> weigher(EntryWeigher<? super K, ? super V> entryWeigher) {
            this.weigher = entryWeigher == Weighers.entrySingleton() ? Weighers.entrySingleton() : new BoundedEntryWeigher<K, V>(entryWeigher);
            return this;
        }

        public ConcurrentLinkedHashMap<K, V> build() {
            ConcurrentLinkedHashMap.checkState(this.capacity >= 0L);
            return new ConcurrentLinkedHashMap(this);
        }
    }

    static final class SerializationProxy<K, V>
    implements Serializable {
        final EntryWeigher<? super K, ? super V> weigher;
        final EvictionListener<K, V> listener;
        final int concurrencyLevel;
        final Map<K, V> data;
        final long capacity;
        static final long serialVersionUID = 1L;

        SerializationProxy(ConcurrentLinkedHashMap<K, V> concurrentLinkedHashMap) {
            this.concurrencyLevel = concurrentLinkedHashMap.concurrencyLevel;
            this.data = new HashMap<K, V>(concurrentLinkedHashMap);
            this.capacity = concurrentLinkedHashMap.capacity.get();
            this.listener = concurrentLinkedHashMap.listener;
            this.weigher = concurrentLinkedHashMap.weigher;
        }

        Object readResolve() {
            ConcurrentLinkedHashMap<K, V> concurrentLinkedHashMap = new Builder().concurrencyLevel(this.concurrencyLevel).maximumWeightedCapacity(this.capacity).listener(this.listener).weigher(this.weigher).build();
            concurrentLinkedHashMap.putAll(this.data);
            return concurrentLinkedHashMap;
        }
    }

    static enum DiscardingListener implements EvictionListener<Object, Object>
    {
        INSTANCE;


        @Override
        public void onEviction(Object object, Object object2) {
        }
    }

    static final class DiscardingQueue
    extends AbstractQueue<Object> {
        DiscardingQueue() {
        }

        @Override
        public boolean add(Object object) {
            return true;
        }

        @Override
        public boolean offer(Object object) {
            return true;
        }

        @Override
        public Object poll() {
            return null;
        }

        @Override
        public Object peek() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyList().iterator();
        }
    }

    static final class BoundedEntryWeigher<K, V>
    implements EntryWeigher<K, V>,
    Serializable {
        static final long serialVersionUID = 1L;
        final EntryWeigher<? super K, ? super V> weigher;

        BoundedEntryWeigher(EntryWeigher<? super K, ? super V> entryWeigher) {
            ConcurrentLinkedHashMap.checkNotNull(entryWeigher);
            this.weigher = entryWeigher;
        }

        @Override
        public int weightOf(K k2, V v2) {
            int n2 = this.weigher.weightOf(k2, v2);
            ConcurrentLinkedHashMap.checkArgument(n2 >= 1);
            return n2;
        }

        Object writeReplace() {
            return this.weigher;
        }
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        static final long serialVersionUID = 1L;

        WriteThroughEntry(Node<K, V> node) {
            super(node.key, node.getValue());
        }

        @Override
        public V setValue(V v2) {
            ConcurrentLinkedHashMap.this.put(this.getKey(), v2);
            return super.setValue(v2);
        }

        Object writeReplace() {
            return new AbstractMap.SimpleEntry(this);
        }
    }

    final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        final Iterator<Node<K, V>> iterator;
        Node<K, V> current;

        EntryIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.iterator.next();
            return new WriteThroughEntry(this.current);
        }

        @Override
        public void remove() {
            ConcurrentLinkedHashMap.checkState(this.current != null);
            ConcurrentLinkedHashMap.this.remove(this.current.key);
            this.current = null;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final ConcurrentLinkedHashMap<K, V> map;

        EntrySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Node node = (Node)this.map.data.get(entry.getKey());
            return node != null && node.getValue().equals(entry.getValue());
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return this.map.putIfAbsent(entry.getKey(), entry.getValue()) == null;
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.map.remove(entry.getKey(), entry.getValue());
        }
    }

    final class ValueIterator
    implements Iterator<V> {
        final Iterator<Node<K, V>> iterator;
        Node<K, V> current;

        ValueIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            this.current = this.iterator.next();
            return this.current.getValue();
        }

        @Override
        public void remove() {
            ConcurrentLinkedHashMap.checkState(this.current != null);
            ConcurrentLinkedHashMap.this.remove(this.current.key);
            this.current = null;
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public int size() {
            return ConcurrentLinkedHashMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentLinkedHashMap.this.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentLinkedHashMap.this.containsValue(object);
        }
    }

    final class KeyIterator
    implements Iterator<K> {
        final Iterator<K> iterator;
        K current;

        KeyIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            ConcurrentLinkedHashMap.checkState(this.current != null);
            ConcurrentLinkedHashMap.this.remove(this.current);
            this.current = null;
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        final ConcurrentLinkedHashMap<K, V> map;

        KeySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentLinkedHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.map.remove(object) != null;
        }

        @Override
        public Object[] toArray() {
            return this.map.data.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.map.data.keySet().toArray(TArray);
        }
    }

    static final class Node<K, V>
    extends AtomicReference<WeightedValue<V>>
    implements Linked<Node<K, V>> {
        final K key;
        @GuardedBy(value="evictionLock")
        Node<K, V> prev;
        @GuardedBy(value="evictionLock")
        Node<K, V> next;

        Node(K k2, WeightedValue<V> weightedValue) {
            super(weightedValue);
            this.key = k2;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public Node<K, V> getPrevious() {
            return this.prev;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void setPrevious(Node<K, V> node) {
            this.prev = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public Node<K, V> getNext() {
            return this.next;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void setNext(Node<K, V> node) {
            this.next = node;
        }

        V getValue() {
            return ((WeightedValue)this.get()).value;
        }
    }

    @Immutable
    static final class WeightedValue<V> {
        final int weight;
        final V value;

        WeightedValue(V v2, int n2) {
            this.weight = n2;
            this.value = v2;
        }

        boolean contains(Object object) {
            return object == this.value || this.value.equals(object);
        }

        boolean isAlive() {
            return this.weight > 0;
        }

        boolean isRetired() {
            return this.weight < 0;
        }

        boolean isDead() {
            return this.weight == 0;
        }
    }

    static enum DrainStatus {
        IDLE{

            @Override
            boolean shouldDrainBuffers(boolean bl) {
                return !bl;
            }
        }
        ,
        REQUIRED{

            @Override
            boolean shouldDrainBuffers(boolean bl) {
                return true;
            }
        }
        ,
        PROCESSING{

            @Override
            boolean shouldDrainBuffers(boolean bl) {
                return false;
            }
        };


        abstract boolean shouldDrainBuffers(boolean var1);
    }

    final class UpdateTask
    implements Runnable {
        final int weightDifference;
        final Node<K, V> node;

        public UpdateTask(Node<K, V> node, int n2) {
            this.weightDifference = n2;
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            ConcurrentLinkedHashMap.this.weightedSize.lazySet(ConcurrentLinkedHashMap.this.weightedSize.get() + (long)this.weightDifference);
            ConcurrentLinkedHashMap.this.applyRead(this.node);
            ConcurrentLinkedHashMap.this.evict();
        }
    }

    final class RemovalTask
    implements Runnable {
        final Node<K, V> node;

        RemovalTask(Node<K, V> node) {
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            ConcurrentLinkedHashMap.this.evictionDeque.remove(this.node);
            ConcurrentLinkedHashMap.this.makeDead(this.node);
        }
    }

    final class AddTask
    implements Runnable {
        final Node<K, V> node;
        final int weight;

        AddTask(Node<K, V> node, int n2) {
            this.weight = n2;
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            ConcurrentLinkedHashMap.this.weightedSize.lazySet(ConcurrentLinkedHashMap.this.weightedSize.get() + (long)this.weight);
            if (((WeightedValue)this.node.get()).isAlive()) {
                ConcurrentLinkedHashMap.this.evictionDeque.add(this.node);
                ConcurrentLinkedHashMap.this.evict();
            }
        }
    }
}

