/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client;

import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;

public class Address {
    private static final Logger LOGGER = LoggerFactory.getLogger(Address.class);
    private final String _host;
    private final int _port;

    public Address(String string, int n2) {
        this._host = string;
        this._port = n2;
    }

    public Address(String string) {
        this._host = string;
        this._port = -1;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public static String parseHost(String string) {
        int n2 = string.lastIndexOf(":");
        int n3 = string.lastIndexOf("]");
        if (n3 == -1) {
            String[] stringArray = string.split(":");
            if (stringArray.length > 2) {
                String string2 = "Address " + string + " seems to contain an unquoted IPv6 address. Make sure you quote IPv6 addresses like so: [2001:db8:85a3:8d3:1319:8a2e:370:7348]";
                LOGGER.error(string2);
                throw new IllegalArgumentException(string2);
            }
            return stringArray[0];
        }
        if (n3 < n2) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static int parsePort(String string) {
        int n2 = string.lastIndexOf(":");
        int n3 = string.lastIndexOf("]");
        if (n3 == -1) {
            String[] stringArray = string.split(":");
            if (stringArray.length > 2) {
                String string2 = "Address " + string + " seems to contain an unquoted IPv6 address. Make sure you quote IPv6 addresses like so: [2001:db8:85a3:8d3:1319:8a2e:370:7348]";
                LOGGER.error(string2);
                throw new IllegalArgumentException(string2);
            }
            if (stringArray.length == 2) {
                return Integer.parseInt(stringArray[1]);
            }
            return -1;
        }
        if (n3 < n2) {
            return Integer.parseInt(string.substring(n2 + 1));
        }
        return -1;
    }

    public static boolean isHostWithPort(String string) {
        int n2 = string.lastIndexOf(":");
        int n3 = string.lastIndexOf("]");
        if (n3 == -1) {
            return string.contains(":");
        }
        return n3 < n2;
    }

    public static Address parseAddress(String string) {
        if (Address.isHostWithPort(string)) {
            return new Address(Address.parseHost(string), Address.parsePort(string));
        }
        return new Address(string);
    }

    public static Address[] parseAddresses(String string) {
        String[] stringArray = string.split(" *, *");
        Address[] addressArray = new Address[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            addressArray[i2] = Address.parseAddress(stringArray[i2]);
        }
        return addressArray;
    }

    public int hashCode() {
        return 31 * this._host.hashCode() + this._port;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Address address = (Address)object;
        return this._host.equals(address._host) && this._port == address._port;
    }

    public String toString() {
        return this._port == -1 ? this._host : this._host + ":" + this._port;
    }
}

