/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConnectionFactory;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.NioParams;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConnectionFactoryConfigurator {
    public static final String DEFAULT_PREFIX = "rabbitmq.";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String VIRTUAL_HOST = "virtual.host";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String CONNECTION_CHANNEL_MAX = "connection.channel.max";
    public static final String CONNECTION_FRAME_MAX = "connection.frame.max";
    public static final String CONNECTION_HEARTBEAT = "connection.heartbeat";
    public static final String CONNECTION_TIMEOUT = "connection.timeout";
    public static final String HANDSHAKE_TIMEOUT = "handshake.timeout";
    public static final String SHUTDOWN_TIMEOUT = "shutdown.timeout";
    public static final String CLIENT_PROPERTIES_PREFIX = "client.properties.";
    public static final String CONNECTION_RECOVERY_ENABLED = "connection.recovery.enabled";
    public static final String TOPOLOGY_RECOVERY_ENABLED = "topology.recovery.enabled";
    public static final String CONNECTION_RECOVERY_INTERVAL = "connection.recovery.interval";
    public static final String CHANNEL_RPC_TIMEOUT = "channel.rpc.timeout";
    public static final String CHANNEL_SHOULD_CHECK_RPC_RESPONSE_TYPE = "channel.should.check.rpc.response.type";
    public static final String USE_NIO = "use.nio";
    public static final String NIO_READ_BYTE_BUFFER_SIZE = "nio.read.byte.buffer.size";
    public static final String NIO_WRITE_BYTE_BUFFER_SIZE = "nio.write.byte.buffer.size";
    public static final String NIO_NB_IO_THREADS = "nio.nb.io.threads";
    public static final String NIO_WRITE_ENQUEUING_TIMEOUT_IN_MS = "nio.write.enqueuing.timeout.in.ms";
    public static final String NIO_WRITE_QUEUE_CAPACITY = "nio.write.queue.capacity";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(ConnectionFactory connectionFactory, String string, String string2) throws IOException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Property file argument cannot be null or empty");
        }
        Properties properties = new Properties();
        if (string.startsWith("classpath:")) {
            InputStream inputStream = null;
            try {
                inputStream = ConnectionFactoryConfigurator.class.getResourceAsStream(string.substring("classpath:".length()));
                properties.load(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        Reader reader = null;
        try {
            reader = new BufferedReader(new FileReader(string));
            properties.load(reader);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        ConnectionFactoryConfigurator.load(connectionFactory, (Map<String, String>)properties, string2);
    }

    public static void load(ConnectionFactory connectionFactory, Map<String, String> map, String string) {
        String string2;
        String string3;
        String string4;
        String string5;
        Map.Entry<String, String> entry2;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        String string11;
        String string12;
        String string13;
        String string14;
        String string15;
        String string16;
        String string17 = map.get((string = string == null ? "" : string) + "uri");
        if (string17 != null) {
            try {
                connectionFactory.setUri(string17);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Error while setting AMQP URI: " + string17, uRISyntaxException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalArgumentException("Error while setting AMQP URI: " + string17, noSuchAlgorithmException);
            }
            catch (KeyManagementException keyManagementException) {
                throw new IllegalArgumentException("Error while setting AMQP URI: " + string17, keyManagementException);
            }
        }
        if ((string16 = map.get(string + USERNAME)) != null) {
            connectionFactory.setUsername(string16);
        }
        if ((string15 = map.get(string + PASSWORD)) != null) {
            connectionFactory.setPassword(string15);
        }
        if ((string14 = map.get(string + VIRTUAL_HOST)) != null) {
            connectionFactory.setVirtualHost(string14);
        }
        if ((string13 = map.get(string + HOST)) != null) {
            connectionFactory.setHost(string13);
        }
        if ((string12 = map.get(string + PORT)) != null) {
            connectionFactory.setPort(Integer.valueOf(string12));
        }
        if ((string11 = map.get(string + CONNECTION_CHANNEL_MAX)) != null) {
            connectionFactory.setRequestedChannelMax(Integer.valueOf(string11));
        }
        if ((string10 = map.get(string + CONNECTION_FRAME_MAX)) != null) {
            connectionFactory.setRequestedFrameMax(Integer.valueOf(string10));
        }
        if ((string9 = map.get(string + CONNECTION_HEARTBEAT)) != null) {
            connectionFactory.setRequestedHeartbeat(Integer.valueOf(string9));
        }
        if ((string8 = map.get(string + CONNECTION_TIMEOUT)) != null) {
            connectionFactory.setConnectionTimeout(Integer.valueOf(string8));
        }
        if ((string7 = map.get(string + HANDSHAKE_TIMEOUT)) != null) {
            connectionFactory.setHandshakeTimeout(Integer.valueOf(string7));
        }
        if ((string6 = map.get(string + SHUTDOWN_TIMEOUT)) != null) {
            connectionFactory.setShutdownTimeout(Integer.valueOf(string6));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map<String, Object> map2 = AMQConnection.defaultClientProperties();
        hashMap.putAll(map2);
        for (Map.Entry<String, String> entry2 : map.entrySet()) {
            if (!entry2.getKey().startsWith(string + CLIENT_PROPERTIES_PREFIX)) continue;
            string5 = entry2.getKey().substring((string + CLIENT_PROPERTIES_PREFIX).length());
            if (map2.containsKey(string5) && (entry2.getValue() == null || ((String)entry2.getValue()).trim().isEmpty())) {
                hashMap.remove(string5);
                continue;
            }
            hashMap.put(string5, entry2.getValue());
        }
        connectionFactory.setClientProperties(hashMap);
        String string18 = map.get(string + CONNECTION_RECOVERY_ENABLED);
        if (string18 != null) {
            connectionFactory.setAutomaticRecoveryEnabled(Boolean.valueOf(string18));
        }
        if ((entry2 = map.get(string + TOPOLOGY_RECOVERY_ENABLED)) != null) {
            connectionFactory.setTopologyRecoveryEnabled(Boolean.getBoolean((String)((Object)entry2)));
        }
        if ((string5 = map.get(string + CONNECTION_RECOVERY_INTERVAL)) != null) {
            connectionFactory.setNetworkRecoveryInterval(Long.valueOf(string5));
        }
        if ((string4 = map.get(string + CHANNEL_RPC_TIMEOUT)) != null) {
            connectionFactory.setChannelRpcTimeout(Integer.valueOf(string4));
        }
        if ((string3 = map.get(string + CHANNEL_SHOULD_CHECK_RPC_RESPONSE_TYPE)) != null) {
            connectionFactory.setChannelShouldCheckRpcResponseType(Boolean.valueOf(string3));
        }
        if ((string2 = map.get(string + USE_NIO)) != null && Boolean.valueOf(string2).booleanValue()) {
            String string19;
            String string20;
            String string21;
            String string22;
            connectionFactory.useNio();
            NioParams nioParams = new NioParams();
            String string23 = map.get(string + NIO_READ_BYTE_BUFFER_SIZE);
            if (string23 != null) {
                nioParams.setReadByteBufferSize(Integer.valueOf(string23));
            }
            if ((string22 = map.get(string + NIO_WRITE_BYTE_BUFFER_SIZE)) != null) {
                nioParams.setWriteByteBufferSize(Integer.valueOf(string22));
            }
            if ((string21 = map.get(string + NIO_NB_IO_THREADS)) != null) {
                nioParams.setNbIoThreads(Integer.valueOf(string21));
            }
            if ((string20 = map.get(string + NIO_WRITE_ENQUEUING_TIMEOUT_IN_MS)) != null) {
                nioParams.setWriteEnqueuingTimeoutInMs(Integer.valueOf(string20));
            }
            if ((string19 = map.get(string + NIO_WRITE_QUEUE_CAPACITY)) != null) {
                nioParams.setWriteQueueCapacity(Integer.valueOf(string19));
            }
            connectionFactory.setNioParams(nioParams);
        }
    }

    public static void load(ConnectionFactory connectionFactory, String string) throws IOException {
        ConnectionFactoryConfigurator.load(connectionFactory, string, DEFAULT_PREFIX);
    }

    public static void load(ConnectionFactory connectionFactory, Properties properties) {
        ConnectionFactoryConfigurator.load(connectionFactory, (Map<String, String>)properties, DEFAULT_PREFIX);
    }

    public static void load(ConnectionFactory connectionFactory, Properties properties, String string) {
        ConnectionFactoryConfigurator.load(connectionFactory, (Map<String, String>)properties, string);
    }

    public static void load(ConnectionFactory connectionFactory, Map<String, String> map) {
        ConnectionFactoryConfigurator.load(connectionFactory, map, DEFAULT_PREFIX);
    }
}

