/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.AMQP;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.AlreadyClosedException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.AuthenticationFailureException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.BlockedListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Channel;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Command;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Connection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ExceptionHandler;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.LongString;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.MetricsCollector;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.MissedHeartbeatException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.NoOpMetricsCollector;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.PossibleAuthenticationFailureException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ProtocolVersionMismatchException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.SaslConfig;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.SaslMechanism;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ShutdownSignalException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.TrafficListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQChannel;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQCommand;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ChannelManager;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ChannelN;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ClientVersion;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ConnectionParams;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ConsumerWorkService;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.CredentialsProvider;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Environment;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ErrorOnWriteListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Frame;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.FrameHandler;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.HeartbeatSender;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.LongStringHelper;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Method;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.NetworkConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ShutdownNotifierComponent;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.UnknownChannelException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Version;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.WorkPoolFullException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecoveryCanBeginListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.utility.BlockingCell;
import com.contrastsecurity.thirdparty.com.rabbitmq.utility.Utility;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class AMQConnection
extends ShutdownNotifierComponent
implements Connection,
NetworkConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMQConnection.class);
    public static final double CHANNEL_SHUTDOWN_TIMEOUT_MULTIPLIER = 1.05;
    private final ExecutorService consumerWorkServiceExecutor;
    private final ScheduledExecutorService heartbeatExecutor;
    private final ExecutorService shutdownExecutor;
    private Thread mainLoopThread;
    private ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private String id;
    private final List<RecoveryCanBeginListener> recoveryCanBeginListeners = Collections.synchronizedList(new ArrayList());
    private final ErrorOnWriteListener errorOnWriteListener;
    private final int workPoolTimeout;
    private final AtomicBoolean finalShutdownStarted = new AtomicBoolean(false);
    private static final Version clientVersion = new Version(0, 9);
    private final AMQChannel _channel0;
    protected ConsumerWorkService _workService = null;
    private final FrameHandler _frameHandler;
    private volatile boolean _running = false;
    private final ExceptionHandler _exceptionHandler;
    private final BlockingCell<Object> _appContinuation = new BlockingCell();
    private volatile boolean _brokerInitiatedShutdown;
    private volatile boolean _inConnectionNegotiation;
    private HeartbeatSender _heartbeatSender;
    private final String _virtualHost;
    private final Map<String, Object> _clientProperties;
    private final SaslConfig saslConfig;
    private final int requestedHeartbeat;
    private final int requestedChannelMax;
    private final int requestedFrameMax;
    private final int handshakeTimeout;
    private final int shutdownTimeout;
    private final CredentialsProvider credentialsProvider;
    private final Collection<BlockedListener> blockedListeners = new CopyOnWriteArrayList<BlockedListener>();
    protected final MetricsCollector metricsCollector;
    private final int channelRpcTimeout;
    private final boolean channelShouldCheckRpcResponseType;
    private final TrafficListener trafficListener;
    private volatile int _frameMax = 0;
    private volatile int _missedHeartbeats = 0;
    private volatile int _heartbeat = 0;
    private volatile ChannelManager _channelManager;
    private volatile Map<String, Object> _serverProperties;
    private static long SOCKET_CLOSE_TIMEOUT = 10000L;

    public static Map<String, Object> defaultClientProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("product", LongStringHelper.asLongString("RabbitMQ"));
        hashMap.put("version", LongStringHelper.asLongString(ClientVersion.VERSION));
        hashMap.put("platform", LongStringHelper.asLongString("Java"));
        hashMap.put("copyright", LongStringHelper.asLongString("Copyright (c) 2007-2018 Pivotal Software, Inc."));
        hashMap.put("information", LongStringHelper.asLongString("Licensed under the MPL. See http://www.rabbitmq.com/"));
        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
        hashMap2.put("publisher_confirms", true);
        hashMap2.put("exchange_exchange_bindings", true);
        hashMap2.put("basic.nack", true);
        hashMap2.put("consumer_cancel_notify", true);
        hashMap2.put("connection.blocked", true);
        hashMap2.put("authentication_failure_close", true);
        hashMap.put("capabilities", hashMap2);
        return hashMap;
    }

    public final void disconnectChannel(ChannelN channelN) {
        ChannelManager channelManager = this._channelManager;
        if (channelManager != null) {
            channelManager.releaseChannelNumber(channelN);
        }
    }

    private void ensureIsOpen() throws AlreadyClosedException {
        if (!this.isOpen()) {
            throw new AlreadyClosedException(this.getCloseReason());
        }
    }

    @Override
    public InetAddress getAddress() {
        return this._frameHandler.getAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this._frameHandler.getLocalAddress();
    }

    @Override
    public int getPort() {
        return this._frameHandler.getPort();
    }

    @Override
    public int getLocalPort() {
        return this._frameHandler.getLocalPort();
    }

    public FrameHandler getFrameHandler() {
        return this._frameHandler;
    }

    @Override
    public Map<String, Object> getServerProperties() {
        return this._serverProperties;
    }

    public AMQConnection(ConnectionParams connectionParams, FrameHandler frameHandler) {
        this(connectionParams, frameHandler, new NoOpMetricsCollector());
    }

    public AMQConnection(ConnectionParams connectionParams, FrameHandler frameHandler, MetricsCollector metricsCollector) {
        AMQConnection.checkPreconditions();
        this.credentialsProvider = connectionParams.getCredentialsProvider();
        this._frameHandler = frameHandler;
        this._virtualHost = connectionParams.getVirtualHost();
        this._exceptionHandler = connectionParams.getExceptionHandler();
        this._clientProperties = new HashMap<String, Object>(connectionParams.getClientProperties());
        this.requestedFrameMax = connectionParams.getRequestedFrameMax();
        this.requestedChannelMax = connectionParams.getRequestedChannelMax();
        this.requestedHeartbeat = connectionParams.getRequestedHeartbeat();
        this.handshakeTimeout = connectionParams.getHandshakeTimeout();
        this.shutdownTimeout = connectionParams.getShutdownTimeout();
        this.saslConfig = connectionParams.getSaslConfig();
        this.consumerWorkServiceExecutor = connectionParams.getConsumerWorkServiceExecutor();
        this.heartbeatExecutor = connectionParams.getHeartbeatExecutor();
        this.shutdownExecutor = connectionParams.getShutdownExecutor();
        this.threadFactory = connectionParams.getThreadFactory();
        if (connectionParams.getChannelRpcTimeout() < 0) {
            throw new IllegalArgumentException("Continuation timeout on RPC calls cannot be less than 0");
        }
        this.channelRpcTimeout = connectionParams.getChannelRpcTimeout();
        this.channelShouldCheckRpcResponseType = connectionParams.channelShouldCheckRpcResponseType();
        this.trafficListener = connectionParams.getTrafficListener() == null ? TrafficListener.NO_OP : connectionParams.getTrafficListener();
        this._channel0 = new AMQChannel(this, 0){

            @Override
            public boolean processAsync(Command command) throws IOException {
                return this.getConnection().processControlCommand(command);
            }
        };
        this._channelManager = null;
        this._brokerInitiatedShutdown = false;
        this._inConnectionNegotiation = true;
        this.metricsCollector = metricsCollector;
        this.errorOnWriteListener = connectionParams.getErrorOnWriteListener() != null ? connectionParams.getErrorOnWriteListener() : new ErrorOnWriteListener(){

            @Override
            public void handle(Connection connection, IOException iOException) throws IOException {
                throw iOException;
            }
        };
        this.workPoolTimeout = connectionParams.getWorkPoolTimeout();
    }

    private void initializeConsumerWorkService() {
        this._workService = new ConsumerWorkService(this.consumerWorkServiceExecutor, this.threadFactory, this.workPoolTimeout, this.shutdownTimeout);
    }

    private void initializeHeartbeatSender() {
        this._heartbeatSender = new HeartbeatSender(this._frameHandler, this.heartbeatExecutor, this.threadFactory);
    }

    public void start() throws IOException, TimeoutException {
        this.initializeConsumerWorkService();
        this.initializeHeartbeatSender();
        this._running = true;
        AMQChannel.SimpleBlockingRpcContinuation simpleBlockingRpcContinuation = new AMQChannel.SimpleBlockingRpcContinuation();
        this._channel0.enqueueRpc(simpleBlockingRpcContinuation);
        try {
            this._frameHandler.setTimeout(this.handshakeTimeout);
            this._frameHandler.sendHeader();
        }
        catch (IOException iOException) {
            this._frameHandler.close();
            throw iOException;
        }
        this._frameHandler.initialize(this);
        AMQP.Connection.Tune tune = null;
        try {
            AMQP.Connection.Start start = (AMQP.Connection.Start)((Object)((AMQCommand)simpleBlockingRpcContinuation.getReply(this.handshakeTimeout / 2)).getMethod());
            this._serverProperties = Collections.unmodifiableMap(start.getServerProperties());
            Version version = new Version(start.getVersionMajor(), start.getVersionMinor());
            if (!Version.checkVersion(clientVersion, version)) {
                throw new ProtocolVersionMismatchException(clientVersion, version);
            }
            String[] stringArray = start.getMechanisms().toString().split(" ");
            SaslMechanism saslMechanism = this.saslConfig.getSaslMechanism(stringArray);
            if (saslMechanism == null) {
                throw new IOException("No compatible authentication mechanism found - server offered [" + start.getMechanisms() + "]");
            }
            String string = this.credentialsProvider.getUsername();
            String string2 = this.credentialsProvider.getPassword();
            LongString longString = null;
            LongString longString2 = saslMechanism.handleChallenge(null, string, string2);
            do {
                AMQP.Connection.SecureOk secureOk = longString == null ? new AMQP.Connection.StartOk.Builder().clientProperties(this._clientProperties).mechanism(saslMechanism.getName()).response(longString2).build() : new AMQP.Connection.SecureOk.Builder().response(longString2).build();
                try {
                    Method method = this._channel0.rpc((com.contrastsecurity.thirdparty.com.rabbitmq.client.Method)secureOk, this.handshakeTimeout / 2).getMethod();
                    if (method instanceof AMQP.Connection.Tune) {
                        tune = (AMQP.Connection.Tune)((Object)method);
                        continue;
                    }
                    longString = ((AMQP.Connection.Secure)((Object)method)).getChallenge();
                    longString2 = saslMechanism.handleChallenge(longString, string, string2);
                }
                catch (ShutdownSignalException shutdownSignalException) {
                    AMQP.Connection.Close close;
                    com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method = shutdownSignalException.getReason();
                    if (method instanceof AMQP.Connection.Close && (close = (AMQP.Connection.Close)method).getReplyCode() == 403) {
                        throw new AuthenticationFailureException(close.getReplyText());
                    }
                    throw new PossibleAuthenticationFailureException(shutdownSignalException);
                }
            } while (tune == null);
        }
        catch (TimeoutException timeoutException) {
            this._frameHandler.close();
            throw timeoutException;
        }
        catch (ShutdownSignalException shutdownSignalException) {
            this._frameHandler.close();
            throw AMQChannel.wrap(shutdownSignalException);
        }
        catch (IOException iOException) {
            this._frameHandler.close();
            throw iOException;
        }
        try {
            int n2;
            int n3 = this.negotiateChannelMax(this.requestedChannelMax, tune.getChannelMax());
            this._channelManager = this.instantiateChannelManager(n3, this.threadFactory);
            this._frameMax = n2 = AMQConnection.negotiatedMaxValue(this.requestedFrameMax, tune.getFrameMax());
            int n4 = AMQConnection.negotiatedMaxValue(this.requestedHeartbeat, tune.getHeartbeat());
            this.setHeartbeat(n4);
            this._channel0.transmit(new AMQP.Connection.TuneOk.Builder().channelMax(n3).frameMax(n2).heartbeat(n4).build());
            this._channel0.exnWrappingRpc(new AMQP.Connection.Open.Builder().virtualHost(this._virtualHost).build());
        }
        catch (IOException iOException) {
            this._heartbeatSender.shutdown();
            this._frameHandler.close();
            throw iOException;
        }
        catch (ShutdownSignalException shutdownSignalException) {
            this._heartbeatSender.shutdown();
            this._frameHandler.close();
            throw AMQChannel.wrap(shutdownSignalException);
        }
        this._inConnectionNegotiation = false;
    }

    protected ChannelManager instantiateChannelManager(int n2, ThreadFactory threadFactory) {
        ChannelManager channelManager = new ChannelManager(this._workService, n2, threadFactory, this.metricsCollector);
        this.configureChannelManager(channelManager);
        return channelManager;
    }

    protected void configureChannelManager(ChannelManager channelManager) {
        channelManager.setShutdownExecutor(this.shutdownExecutor);
        channelManager.setChannelShutdownTimeout((int)((double)this.requestedHeartbeat * 1.05 * 1000.0));
    }

    public void startMainLoop() {
        MainLoop mainLoop = new MainLoop();
        String string = "AMQP Connection " + this.getHostAddress() + ":" + this.getPort();
        this.mainLoopThread = Environment.newThread(this.threadFactory, mainLoop, string);
        this.mainLoopThread.start();
    }

    protected int negotiateChannelMax(int n2, int n3) {
        return AMQConnection.negotiatedMaxValue(n2, n3);
    }

    private static void checkPreconditions() {
        AMQCommand.checkPreconditions();
    }

    @Override
    public int getChannelMax() {
        ChannelManager channelManager = this._channelManager;
        if (channelManager == null) {
            return 0;
        }
        return channelManager.getChannelMax();
    }

    @Override
    public int getFrameMax() {
        return this._frameMax;
    }

    @Override
    public int getHeartbeat() {
        return this._heartbeat;
    }

    public void setHeartbeat(int n2) {
        try {
            this._heartbeatSender.setHeartbeat(n2);
            this._heartbeat = n2;
            this._frameHandler.setTimeout(n2 * 1000 / 4);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public Map<String, Object> getClientProperties() {
        return new HashMap<String, Object>(this._clientProperties);
    }

    @Override
    public String getClientProvidedName() {
        return (String)this._clientProperties.get("connection_name");
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this._exceptionHandler;
    }

    public boolean willShutDownConsumerExecutor() {
        return this._workService.usesPrivateExecutor();
    }

    @Override
    public Channel createChannel(int n2) throws IOException {
        this.ensureIsOpen();
        ChannelManager channelManager = this._channelManager;
        if (channelManager == null) {
            return null;
        }
        ChannelN channelN = channelManager.createChannel(this, n2);
        this.metricsCollector.newChannel(channelN);
        return channelN;
    }

    @Override
    public Channel createChannel() throws IOException {
        this.ensureIsOpen();
        ChannelManager channelManager = this._channelManager;
        if (channelManager == null) {
            return null;
        }
        ChannelN channelN = channelManager.createChannel(this);
        this.metricsCollector.newChannel(channelN);
        return channelN;
    }

    public void writeFrame(Frame frame) throws IOException {
        this._frameHandler.writeFrame(frame);
        this._heartbeatSender.signalActivity();
    }

    public void flush() throws IOException {
        try {
            this._frameHandler.flush();
        }
        catch (IOException iOException) {
            this.errorOnWriteListener.handle(this, iOException);
        }
    }

    private static int negotiatedMaxValue(int n2, int n3) {
        return n2 == 0 || n3 == 0 ? Math.max(n2, n3) : Math.min(n2, n3);
    }

    public boolean handleReadFrame(Frame frame) {
        if (this._running) {
            try {
                this.readFrame(frame);
                return true;
            }
            catch (WorkPoolFullException workPoolFullException) {
                throw workPoolFullException;
            }
            catch (Throwable throwable) {
                try {
                    this.handleFailure(throwable);
                }
                finally {
                    this.doFinalShutdown();
                }
            }
        }
        return false;
    }

    public boolean isRunning() {
        return this._running;
    }

    public boolean hasBrokerInitiatedShutdown() {
        return this._brokerInitiatedShutdown;
    }

    private void readFrame(Frame frame) throws IOException {
        if (frame != null) {
            this._missedHeartbeats = 0;
            if (frame.type != 8) {
                ChannelManager channelManager;
                if (frame.channel == 0) {
                    this._channel0.handleFrame(frame);
                } else if (this.isOpen() && (channelManager = this._channelManager) != null) {
                    ChannelN channelN;
                    try {
                        channelN = channelManager.getChannel(frame.channel);
                    }
                    catch (UnknownChannelException unknownChannelException) {
                        LOGGER.info("Received a frame on an unknown channel, ignoring it");
                        return;
                    }
                    channelN.handleFrame(frame);
                }
            }
        } else {
            this.handleSocketTimeout();
        }
    }

    public void handleHeartbeatFailure() {
        MissedHeartbeatException missedHeartbeatException = new MissedHeartbeatException("Heartbeat missing with heartbeat = " + this._heartbeat + " seconds");
        try {
            this._exceptionHandler.handleUnexpectedConnectionDriverException(this, missedHeartbeatException);
            this.shutdown(null, false, missedHeartbeatException, true);
        }
        finally {
            this.doFinalShutdown();
        }
    }

    public void handleIoError(Throwable throwable) {
        try {
            this.handleFailure(throwable);
        }
        finally {
            this.doFinalShutdown();
        }
    }

    private void handleFailure(Throwable throwable) {
        if (throwable instanceof EOFException) {
            if (!this._brokerInitiatedShutdown) {
                this.shutdown(null, false, throwable, true);
            }
        } else {
            this._exceptionHandler.handleUnexpectedConnectionDriverException(this, throwable);
            this.shutdown(null, false, throwable, true);
        }
    }

    public void doFinalShutdown() {
        if (this.finalShutdownStarted.compareAndSet(false, true)) {
            this._frameHandler.close();
            this._appContinuation.set(null);
            this.closeMainLoopThreadIfNecessary();
            this.notifyListeners();
            this.notifyRecoveryCanBeginListeners();
        }
    }

    private void closeMainLoopThreadIfNecessary() {
        if (this.mainLoopReadThreadNotNull() && this.notInMainLoopThread() && this.mainLoopThread.isAlive()) {
            this.mainLoopThread.interrupt();
        }
    }

    private boolean notInMainLoopThread() {
        return Thread.currentThread() != this.mainLoopThread;
    }

    private boolean mainLoopReadThreadNotNull() {
        return this.mainLoopThread != null;
    }

    private void notifyRecoveryCanBeginListeners() {
        ShutdownSignalException shutdownSignalException = this.getCloseReason();
        for (RecoveryCanBeginListener recoveryCanBeginListener : Utility.copy(this.recoveryCanBeginListeners)) {
            recoveryCanBeginListener.recoveryCanBegin(shutdownSignalException);
        }
    }

    public void addRecoveryCanBeginListener(RecoveryCanBeginListener recoveryCanBeginListener) {
        this.recoveryCanBeginListeners.add(recoveryCanBeginListener);
    }

    public void removeRecoveryCanBeginListener(RecoveryCanBeginListener recoveryCanBeginListener) {
        this.recoveryCanBeginListeners.remove(recoveryCanBeginListener);
    }

    private void handleSocketTimeout() throws SocketTimeoutException {
        if (this._inConnectionNegotiation) {
            throw new SocketTimeoutException("Timeout during Connection negotiation");
        }
        if (this._heartbeat == 0) {
            return;
        }
        if (++this._missedHeartbeats > 8) {
            throw new MissedHeartbeatException("Heartbeat missing with heartbeat = " + this._heartbeat + " seconds");
        }
    }

    public boolean processControlCommand(Command command) throws IOException {
        com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method = command.getMethod();
        if (this.isOpen()) {
            if (method instanceof AMQP.Connection.Close) {
                this.handleConnectionClose(command);
                return true;
            }
            if (method instanceof AMQP.Connection.Blocked) {
                AMQP.Connection.Blocked blocked = (AMQP.Connection.Blocked)method;
                try {
                    for (BlockedListener blockedListener : this.blockedListeners) {
                        blockedListener.handleBlocked(blocked.getReason());
                    }
                }
                catch (Throwable throwable) {
                    this.getExceptionHandler().handleBlockedListenerException(this, throwable);
                }
                return true;
            }
            if (method instanceof AMQP.Connection.Unblocked) {
                try {
                    for (BlockedListener blockedListener : this.blockedListeners) {
                        blockedListener.handleUnblocked();
                    }
                }
                catch (Throwable throwable) {
                    this.getExceptionHandler().handleBlockedListenerException(this, throwable);
                }
                return true;
            }
            return false;
        }
        if (method instanceof AMQP.Connection.Close) {
            try {
                this._channel0.quiescingTransmit(new AMQP.Connection.CloseOk.Builder().build());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        if (method instanceof AMQP.Connection.CloseOk) {
            this._running = false;
            return !this._channel0.isOutstandingRpc();
        }
        return true;
    }

    public void handleConnectionClose(Command command) {
        ShutdownSignalException shutdownSignalException = this.shutdown(command.getMethod(), false, null, this._inConnectionNegotiation);
        try {
            this._channel0.quiescingTransmit(new AMQP.Connection.CloseOk.Builder().build());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._brokerInitiatedShutdown = true;
        SocketCloseWait socketCloseWait = new SocketCloseWait(shutdownSignalException);
        if (this.shutdownExecutor != null) {
            this.shutdownExecutor.execute(socketCloseWait);
        } else {
            String string = "RabbitMQ connection shutdown monitor " + this.getHostAddress() + ":" + this.getPort();
            Thread thread = Environment.newThread(this.threadFactory, socketCloseWait, string);
            thread.start();
        }
    }

    public ShutdownSignalException shutdown(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method, boolean bl, Throwable throwable, boolean bl2) {
        ShutdownSignalException shutdownSignalException = this.startShutdown(method, bl, throwable, bl2);
        this.finishShutdown(shutdownSignalException);
        return shutdownSignalException;
    }

    private ShutdownSignalException startShutdown(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method, boolean bl, Throwable throwable, boolean bl2) {
        ShutdownSignalException shutdownSignalException = new ShutdownSignalException(true, bl, method, this);
        shutdownSignalException.initCause(throwable);
        if (!this.setShutdownCauseIfOpen(shutdownSignalException) && bl) {
            throw new AlreadyClosedException(this.getCloseReason(), throwable);
        }
        this._heartbeatSender.shutdown();
        this._channel0.processShutdownSignal(shutdownSignalException, !bl, bl2);
        return shutdownSignalException;
    }

    private void finishShutdown(ShutdownSignalException shutdownSignalException) {
        ChannelManager channelManager = this._channelManager;
        if (channelManager != null) {
            channelManager.handleSignal(shutdownSignalException);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(-1);
    }

    @Override
    public void close(int n2) throws IOException {
        this.close(200, "OK", n2);
    }

    @Override
    public void close(int n2, String string) throws IOException {
        this.close(n2, string, -1);
    }

    @Override
    public void close(int n2, String string, int n3) throws IOException {
        this.close(n2, string, true, null, n3, false);
    }

    @Override
    public void abort() {
        this.abort(-1);
    }

    @Override
    public void abort(int n2, String string) {
        this.abort(n2, string, -1);
    }

    @Override
    public void abort(int n2) {
        this.abort(200, "OK", n2);
    }

    @Override
    public void abort(int n2, String string, int n3) {
        try {
            this.close(n2, string, true, null, n3, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close(int n2, String string, boolean bl, Throwable throwable) throws IOException {
        this.close(n2, string, bl, throwable, -1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int n2, String string, boolean bl, Throwable throwable, int n3, boolean bl2) throws IOException {
        boolean bl3 = Thread.currentThread() != this.mainLoopThread;
        try {
            AMQP.Connection.Close close = new AMQP.Connection.Close.Builder().replyCode(n2).replyText(string).build();
            final ShutdownSignalException shutdownSignalException = this.startShutdown(close, bl, throwable, true);
            if (bl3) {
                AMQChannel.BlockingRpcContinuation<AMQCommand> blockingRpcContinuation = new AMQChannel.BlockingRpcContinuation<AMQCommand>(){

                    @Override
                    public AMQCommand transformReply(AMQCommand aMQCommand) {
                        AMQConnection.this.finishShutdown(shutdownSignalException);
                        return aMQCommand;
                    }
                };
                this._channel0.quiescingRpc(close, blockingRpcContinuation);
                blockingRpcContinuation.getReply(n3);
            } else {
                this._channel0.quiescingTransmit(close);
            }
        }
        catch (TimeoutException timeoutException) {
            if (!bl2) {
                ShutdownSignalException shutdownSignalException = new ShutdownSignalException(true, true, null, this);
                shutdownSignalException.initCause(throwable);
                throw shutdownSignalException;
            }
        }
        catch (ShutdownSignalException shutdownSignalException) {
            if (!bl2) {
                throw shutdownSignalException;
            }
        }
        catch (IOException iOException) {
            if (!bl2) {
                throw iOException;
            }
        }
        finally {
            if (bl3) {
                this._frameHandler.close();
            }
        }
    }

    public String toString() {
        String string = "/".equals(this._virtualHost) ? this._virtualHost : "/" + this._virtualHost;
        return "amqp://" + this.credentialsProvider.getUsername() + "@" + this.getHostAddress() + ":" + this.getPort() + string;
    }

    private String getHostAddress() {
        return this.getAddress() == null ? null : this.getAddress().getHostAddress();
    }

    @Override
    public void addBlockedListener(BlockedListener blockedListener) {
        this.blockedListeners.add(blockedListener);
    }

    @Override
    public boolean removeBlockedListener(BlockedListener blockedListener) {
        return this.blockedListeners.remove(blockedListener);
    }

    @Override
    public void clearBlockedListeners() {
        this.blockedListeners.clear();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    public int getChannelRpcTimeout() {
        return this.channelRpcTimeout;
    }

    public boolean willCheckRpcResponseType() {
        return this.channelShouldCheckRpcResponseType;
    }

    public TrafficListener getTrafficListener() {
        return this.trafficListener;
    }

    private class SocketCloseWait
    implements Runnable {
        private final ShutdownSignalException cause;

        public SocketCloseWait(ShutdownSignalException shutdownSignalException) {
            this.cause = shutdownSignalException;
        }

        @Override
        public void run() {
            try {
                AMQConnection.this._appContinuation.get(SOCKET_CLOSE_TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException timeoutException) {
            }
            finally {
                AMQConnection.this._running = false;
                AMQConnection.this._channel0.notifyOutstandingRpc(this.cause);
            }
        }
    }

    private class MainLoop
    implements Runnable {
        private MainLoop() {
        }

        @Override
        public void run() {
            boolean bl = true;
            try {
                while (AMQConnection.this._running) {
                    Frame frame = AMQConnection.this._frameHandler.readFrame();
                    AMQConnection.this.readFrame(frame);
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof InterruptedException) {
                    bl = false;
                } else {
                    AMQConnection.this.handleFailure(throwable);
                }
            }
            finally {
                if (bl) {
                    AMQConnection.this.doFinalShutdown();
                }
            }
        }
    }
}

