/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.Channel;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.WorkPool;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class ConsumerWorkService {
    private static final int MAX_RUNNABLE_BLOCK_SIZE = 16;
    private static final int DEFAULT_NUM_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private final ExecutorService executor;
    private final boolean privateExecutor;
    private final WorkPool<Channel, Runnable> workPool;
    private final int shutdownTimeout;

    public ConsumerWorkService(ExecutorService executorService, ThreadFactory threadFactory, int n2, int n3) {
        this.privateExecutor = executorService == null;
        this.executor = executorService == null ? Executors.newFixedThreadPool(DEFAULT_NUM_THREADS, threadFactory) : executorService;
        this.workPool = new WorkPool(n2);
        this.shutdownTimeout = n3;
    }

    public ConsumerWorkService(ExecutorService executorService, ThreadFactory threadFactory, int n2) {
        this(executorService, threadFactory, -1, n2);
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void shutdown() {
        this.workPool.unregisterAllKeys();
        if (this.privateExecutor) {
            this.executor.shutdown();
        }
    }

    public void stopWork(Channel channel) {
        this.workPool.unregisterKey(channel);
    }

    public void registerKey(Channel channel) {
        this.workPool.registerKey(channel);
    }

    public void setUnlimited(Channel channel, boolean bl) {
        if (bl) {
            this.workPool.unlimit(channel);
        } else {
            this.workPool.limit(channel);
        }
    }

    public void addWork(Channel channel, Runnable runnable) {
        if (this.workPool.addWorkItem(channel, runnable)) {
            this.executor.execute(new WorkPoolRunnable());
        }
    }

    public boolean usesPrivateExecutor() {
        return this.privateExecutor;
    }

    private final class WorkPoolRunnable
    implements Runnable {
        private WorkPoolRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n2 = 16;
            ArrayList arrayList = new ArrayList(n2);
            try {
                Channel channel = (Channel)ConsumerWorkService.this.workPool.nextWorkBlock(arrayList, n2);
                if (channel == null) {
                    return;
                }
                try {
                    for (Runnable runnable : arrayList) {
                        runnable.run();
                    }
                }
                finally {
                    if (ConsumerWorkService.this.workPool.finishWorkBlock(channel)) {
                        ConsumerWorkService.this.executor.execute(new WorkPoolRunnable());
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

