/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Environment;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Frame;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.NioLoopContext;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.NioParams;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.SelectorHolder;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.SocketChannelFrameHandlerState;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.SocketChannelRegistration;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.WriteRequest;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;

public class NioLoop
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NioLoop.class);
    private final NioLoopContext context;
    private final NioParams nioParams;
    private final ExecutorService connectionShutdownExecutor;

    public NioLoop(NioParams nioParams, NioLoopContext nioLoopContext) {
        this.nioParams = nioParams;
        this.context = nioLoopContext;
        this.connectionShutdownExecutor = nioParams.getConnectionShutdownExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SelectorHolder selectorHolder = this.context.readSelectorState;
        Selector selector = selectorHolder.selector;
        Set<SocketChannelRegistration> set = selectorHolder.registrations;
        ByteBuffer byteBuffer = this.context.readBuffer;
        SelectorHolder selectorHolder2 = this.context.writeSelectorState;
        Selector selector2 = selectorHolder2.selector;
        Set<SocketChannelRegistration> set2 = selectorHolder2.registrations;
        boolean bl = false;
        try {
            while (!Thread.currentThread().isInterrupted()) {
                Object object;
                Object object2;
                Iterator<Object> iterator;
                int n2;
                Object object3;
                for (SelectionKey selectionKey : selector.keys()) {
                    long l2;
                    object3 = (SocketChannelFrameHandlerState)selectionKey.attachment();
                    if (((SocketChannelFrameHandlerState)object3).getConnection() == null || ((SocketChannelFrameHandlerState)object3).getConnection().getHeartbeat() <= 0 || (l2 = System.currentTimeMillis()) - ((SocketChannelFrameHandlerState)object3).getLastActivity() <= (long)(((SocketChannelFrameHandlerState)object3).getConnection().getHeartbeat() * 1000 * 2)) continue;
                    try {
                        this.handleHeartbeatFailure((SocketChannelFrameHandlerState)object3);
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Error after heartbeat failure of connection {}", (Object)((SocketChannelFrameHandlerState)object3).getConnection());
                    }
                    catch (AssertionError assertionError) {
                        LOGGER.warn("Assertion error after heartbeat failure of connection {}", (Object)((SocketChannelFrameHandlerState)object3).getConnection());
                    }
                    finally {
                        selectionKey.cancel();
                    }
                }
                if (!bl && set.isEmpty() && set2.isEmpty()) {
                    boolean bl2;
                    n2 = selector.select(1000L);
                    if (selector.keys().size() == 0 && (bl2 = this.context.cleanUp())) {
                        return;
                    }
                } else {
                    n2 = selector.selectNow();
                }
                bl = false;
                object3 = set.iterator();
                while (object3.hasNext()) {
                    SocketChannelRegistration socketChannelRegistration = (SocketChannelRegistration)object3.next();
                    object3.remove();
                    int n3 = socketChannelRegistration.operations;
                    socketChannelRegistration.state.getChannel().register(selector, n3, socketChannelRegistration.state);
                }
                if (n2 > 0) {
                    Set<SelectionKey> set3 = selector.selectedKeys();
                    iterator = set3.iterator();
                    while (iterator.hasNext()) {
                        SelectionKey selectionKey = (SelectionKey)iterator.next();
                        iterator.remove();
                        if (!selectionKey.isValid() || !selectionKey.isReadable()) continue;
                        object2 = (SocketChannelFrameHandlerState)selectionKey.attachment();
                        try {
                            if (!((SocketChannelFrameHandlerState)object2).getChannel().isOpen()) {
                                selectionKey.cancel();
                                continue;
                            }
                            if (((SocketChannelFrameHandlerState)object2).getConnection() == null) continue;
                            ((SocketChannelFrameHandlerState)object2).prepareForReadSequence();
                            while (((SocketChannelFrameHandlerState)object2).continueReading()) {
                                object = ((SocketChannelFrameHandlerState)object2).frameBuilder.readFrame();
                                if (object == null) continue;
                                try {
                                    boolean bl3 = ((SocketChannelFrameHandlerState)object2).getConnection().handleReadFrame((Frame)object);
                                    if (!bl3 || ((SocketChannelFrameHandlerState)object2).getConnection().isRunning() && !((SocketChannelFrameHandlerState)object2).getConnection().hasBrokerInitiatedShutdown()) continue;
                                    this.dispatchShutdownToConnection((SocketChannelFrameHandlerState)object2);
                                    selectionKey.cancel();
                                }
                                catch (Throwable throwable) {
                                    this.handleIoError((SocketChannelFrameHandlerState)object2, throwable);
                                    selectionKey.cancel();
                                }
                                break;
                            }
                            ((SocketChannelFrameHandlerState)object2).setLastActivity(System.currentTimeMillis());
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Error during reading frames", exception);
                            this.handleIoError((SocketChannelFrameHandlerState)object2, exception);
                            selectionKey.cancel();
                        }
                        finally {
                            byteBuffer.clear();
                        }
                    }
                }
                n2 = selector2.selectNow();
                iterator = set2.iterator();
                while (iterator.hasNext()) {
                    SocketChannelRegistration socketChannelRegistration = (SocketChannelRegistration)iterator.next();
                    iterator.remove();
                    int n4 = socketChannelRegistration.operations;
                    try {
                        if (!socketChannelRegistration.state.getChannel().isOpen()) continue;
                        socketChannelRegistration.state.getChannel().register(selector2, n4, socketChannelRegistration.state);
                        bl = true;
                    }
                    catch (Exception exception) {
                        LOGGER.info("Error while registering socket channel for write: {}", (Object)exception.getMessage());
                    }
                }
                if (n2 <= 0) continue;
                Set<SelectionKey> set4 = selector2.selectedKeys();
                object2 = set4.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    object2.remove();
                    SocketChannelFrameHandlerState socketChannelFrameHandlerState = (SocketChannelFrameHandlerState)((SelectionKey)object).attachment();
                    if (!((SelectionKey)object).isValid() || !((SelectionKey)object).isWritable()) continue;
                    boolean bl4 = true;
                    try {
                        WriteRequest writeRequest;
                        if (!socketChannelFrameHandlerState.getChannel().isOpen()) {
                            ((SelectionKey)object).cancel();
                            continue;
                        }
                        socketChannelFrameHandlerState.prepareForWriteSequence();
                        int n5 = socketChannelFrameHandlerState.getWriteQueue().size();
                        DataOutputStream dataOutputStream = socketChannelFrameHandlerState.outputStream;
                        for (int i2 = 0; i2 <= n5 && (writeRequest = socketChannelFrameHandlerState.getWriteQueue().poll()) != null; ++i2) {
                            writeRequest.handle(dataOutputStream);
                        }
                        dataOutputStream.flush();
                        if (socketChannelFrameHandlerState.getWriteQueue().isEmpty()) continue;
                        bl4 = true;
                    }
                    catch (Exception exception) {
                        this.handleIoError(socketChannelFrameHandlerState, exception);
                    }
                    finally {
                        socketChannelFrameHandlerState.endWriteSequence();
                        if (!bl4) continue;
                        ((SelectionKey)object).cancel();
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error in NIO loop", exception);
        }
    }

    protected void handleIoError(SocketChannelFrameHandlerState socketChannelFrameHandlerState, Throwable throwable) {
        if (this.needToDispatchIoError(socketChannelFrameHandlerState)) {
            this.dispatchIoErrorToConnection(socketChannelFrameHandlerState, throwable);
        } else {
            try {
                socketChannelFrameHandlerState.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void handleHeartbeatFailure(final SocketChannelFrameHandlerState socketChannelFrameHandlerState) {
        if (this.needToDispatchIoError(socketChannelFrameHandlerState)) {
            this.dispatchShutdownToConnection(new Runnable(){

                @Override
                public void run() {
                    socketChannelFrameHandlerState.getConnection().handleHeartbeatFailure();
                }
            }, socketChannelFrameHandlerState.getConnection().toString());
        } else {
            try {
                socketChannelFrameHandlerState.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected boolean needToDispatchIoError(SocketChannelFrameHandlerState socketChannelFrameHandlerState) {
        return socketChannelFrameHandlerState.getConnection().isOpen();
    }

    protected void dispatchIoErrorToConnection(final SocketChannelFrameHandlerState socketChannelFrameHandlerState, final Throwable throwable) {
        this.dispatchShutdownToConnection(new Runnable(){

            @Override
            public void run() {
                socketChannelFrameHandlerState.getConnection().handleIoError(throwable);
            }
        }, socketChannelFrameHandlerState.getConnection().toString());
    }

    protected void dispatchShutdownToConnection(final SocketChannelFrameHandlerState socketChannelFrameHandlerState) {
        this.dispatchShutdownToConnection(new Runnable(){

            @Override
            public void run() {
                socketChannelFrameHandlerState.getConnection().doFinalShutdown();
            }
        }, socketChannelFrameHandlerState.getConnection().toString());
    }

    protected void dispatchShutdownToConnection(Runnable runnable, String string) {
        if (this.connectionShutdownExecutor != null) {
            this.connectionShutdownExecutor.execute(runnable);
        } else if (this.executorService() != null) {
            this.executorService().execute(runnable);
        } else {
            String string2 = "rabbitmq-connection-shutdown-" + string;
            Thread thread = Environment.newThread(this.threadFactory(), runnable, string2);
            thread.start();
        }
    }

    private ExecutorService executorService() {
        return this.nioParams.getNioExecutor();
    }

    private ThreadFactory threadFactory() {
        return this.nioParams.getThreadFactory();
    }
}

