/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dagger.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public final class DaggerCollections {
    private static final int MAX_POWER_OF_TWO = 0x40000000;

    private DaggerCollections() {
    }

    public static <T> List<T> presizedList(int n2) {
        if (n2 == 0) {
            return Collections.emptyList();
        }
        return new ArrayList(n2);
    }

    public static boolean hasDuplicates(List<?> list) {
        if (list.size() < 2) {
            return false;
        }
        HashSet hashSet = new HashSet(list);
        return list.size() != hashSet.size();
    }

    static <T> HashSet<T> newHashSetWithExpectedSize(int n2) {
        return new HashSet(DaggerCollections.calculateInitialCapacity(n2));
    }

    static <K, V> LinkedHashMap<K, V> newLinkedHashMapWithExpectedSize(int n2) {
        return new LinkedHashMap(DaggerCollections.calculateInitialCapacity(n2));
    }

    private static int calculateInitialCapacity(int n2) {
        if (n2 < 3) {
            return n2 + 1;
        }
        if (n2 < 0x40000000) {
            return (int)((float)n2 / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }
}

