/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dagger.internal;

import com.contrastsecurity.thirdparty.dagger.internal.DaggerCollections;
import com.contrastsecurity.thirdparty.dagger.internal.Factory;
import com.contrastsecurity.thirdparty.javax.inject.Provider;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MapProviderFactory<K, V>
implements Factory<Map<K, Provider<V>>> {
    private static final MapProviderFactory<Object, Object> EMPTY = new MapProviderFactory(Collections.emptyMap());
    private final Map<K, Provider<V>> contributingMap;

    public static <K, V> Builder<K, V> builder(int n2) {
        return new Builder(n2);
    }

    public static <K, V> MapProviderFactory<K, V> empty() {
        return EMPTY;
    }

    private MapProviderFactory(Map<K, Provider<V>> map) {
        this.contributingMap = Collections.unmodifiableMap(map);
    }

    @Override
    public Map<K, Provider<V>> get() {
        return this.contributingMap;
    }

    public static final class Builder<K, V> {
        private final LinkedHashMap<K, Provider<V>> mapBuilder;

        private Builder(int n2) {
            this.mapBuilder = DaggerCollections.newLinkedHashMapWithExpectedSize(n2);
        }

        public MapProviderFactory<K, V> build() {
            return new MapProviderFactory(this.mapBuilder);
        }

        public Builder<K, V> put(K k2, Provider<V> provider) {
            if (k2 == null) {
                throw new NullPointerException("The key is null");
            }
            if (provider == null) {
                throw new NullPointerException("The provider of the value is null");
            }
            this.mapBuilder.put(k2, provider);
            return this;
        }
    }
}

