/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.jregex;

import com.contrastsecurity.thirdparty.jregex.Bitset;
import com.contrastsecurity.thirdparty.jregex.UnicodeConstants;

class Block
implements UnicodeConstants {
    private boolean isFull;
    boolean[] bits;
    private boolean shared = false;
    private static final boolean[] EMPTY_BITS = new boolean[256];
    private static final boolean[] FULL_BITS = new boolean[256];

    Block() {
    }

    Block(boolean[] blArray) {
        this.bits = blArray;
        this.shared = true;
    }

    final boolean set(int n2) {
        if (this.isFull) {
            return false;
        }
        boolean[] blArray = this.bits;
        if (blArray == null) {
            this.bits = blArray = new boolean[256];
            this.shared = false;
            blArray[n2] = true;
            return true;
        }
        if (blArray[n2]) {
            return false;
        }
        if (this.shared) {
            blArray = Block.copyBits(this);
        }
        blArray[n2] = true;
        return true;
    }

    final boolean get(int n2) {
        if (this.isFull) {
            return true;
        }
        boolean[] blArray = this.bits;
        if (blArray == null) {
            return false;
        }
        return blArray[n2];
    }

    static final int add(Block[] blockArray, Block[] blockArray2, int n2, int n3, boolean bl) {
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            Block block = blockArray2[i2];
            if (block != null ? block.isFull && bl : !bl) continue;
            Block block2 = blockArray[i2];
            if (block2 == null) {
                blockArray[i2] = block2 = new Block();
            } else if (block2.isFull) continue;
            n4 += Block.add(block2, block, bl);
        }
        return n4;
    }

    private static final int add(Block block, Block block2, boolean bl) {
        if (block2 == null) {
            if (!bl) {
                return 0;
            }
            int n2 = 256;
            boolean[] blArray = block.bits;
            if (block.bits != null) {
                n2 -= Block.count(blArray, 0, 255);
            }
            block.isFull = true;
            block.bits = null;
            block.shared = false;
            return n2;
        }
        if (block2.isFull) {
            if (bl) {
                return 0;
            }
            int n3 = 256;
            boolean[] blArray = block.bits;
            if (block.bits != null) {
                n3 -= Block.count(blArray, 0, 255);
            }
            block.isFull = true;
            block.bits = null;
            block.shared = false;
            return n3;
        }
        boolean[] blArray = block2.bits;
        if (block2.bits == null) {
            if (!bl) {
                return 0;
            }
            int n4 = 256;
            boolean[] blArray2 = block.bits;
            if (block.bits != null) {
                n4 -= Block.count(blArray2, 0, 255);
            }
            block.isFull = true;
            block.bits = null;
            block.shared = false;
            return n4;
        }
        boolean[] blArray3 = block.bits;
        if (block.bits == null) {
            if (!bl) {
                block.bits = blArray;
                block.shared = true;
                return Block.count(blArray, 0, 255);
            }
            block.bits = blArray3 = Block.emptyBits(null);
            block.shared = false;
            return Bitset.add(blArray3, blArray, 0, 255, bl);
        }
        if (block.shared) {
            blArray3 = Block.copyBits(block);
        }
        return Bitset.add(blArray3, blArray, 0, 255, bl);
    }

    static final int subtract(Block[] blockArray, Block[] blockArray2, int n2, int n3, boolean bl) {
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            Block block = blockArray[i2];
            if (block == null || !block.isFull && block.bits == null) continue;
            Block block2 = blockArray2[i2];
            if (block2 == null) {
                if (!bl) continue;
                n4 = block.isFull ? (n4 -= 256) : (n4 -= Block.count(block.bits, 0, 255));
                block.isFull = false;
                block.bits = null;
                block.shared = false;
                continue;
            }
            n4 += Block.subtract(block, block2, bl);
        }
        return n4;
    }

    private static final int subtract(Block block, Block block2, boolean bl) {
        if (block2.isFull) {
            if (bl) {
                return 0;
            }
            int n2 = 0;
            n2 = block.isFull ? 256 : Block.count(block.bits, 0, 255);
            block.isFull = false;
            block.bits = null;
            block.shared = false;
            return n2;
        }
        boolean[] blArray = block2.bits;
        if (block2.bits == null) {
            if (!bl) {
                return 0;
            }
            int n3 = 0;
            n3 = block.isFull ? 256 : Block.count(block.bits, 0, 255);
            block.isFull = false;
            block.bits = null;
            block.shared = false;
            return n3;
        }
        if (block.isFull) {
            boolean[] blArray2 = Block.fullBits(block.bits);
            int n4 = Bitset.subtract(blArray2, blArray, 0, 255, bl);
            block.isFull = false;
            block.shared = false;
            block.bits = blArray2;
            return n4;
        }
        boolean[] blArray3 = block.shared ? Block.copyBits(block) : block.bits;
        return Bitset.subtract(blArray3, blArray, 0, 255, bl);
    }

    private static boolean[] copyBits(Block block) {
        boolean[] blArray = new boolean[256];
        System.arraycopy(block.bits, 0, blArray, 0, 256);
        block.bits = blArray;
        block.shared = false;
        return blArray;
    }

    private static boolean[] fullBits(boolean[] blArray) {
        if (blArray == null) {
            blArray = new boolean[256];
        }
        System.arraycopy(FULL_BITS, 0, blArray, 0, 256);
        return blArray;
    }

    private static boolean[] emptyBits(boolean[] blArray) {
        if (blArray == null) {
            blArray = new boolean[256];
        } else {
            System.arraycopy(EMPTY_BITS, 0, blArray, 0, 256);
        }
        return blArray;
    }

    static final int count(boolean[] blArray, int n2, int n3) {
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!blArray[i2]) continue;
            ++n4;
        }
        return n4;
    }

    static final boolean[][] toBitset2(Block[] blockArray) {
        int n2 = blockArray.length;
        boolean[][] blArrayArray = new boolean[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            Block block = blockArray[i2];
            if (block == null) continue;
            blArrayArray[i2] = block.isFull ? FULL_BITS : block.bits;
        }
        return blArrayArray;
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            Block.FULL_BITS[i2] = true;
        }
    }
}

