/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select;

import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.Expression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.OracleHint;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.schema.Table;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Distinct;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Fetch;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.First;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.FromItem;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Join;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Limit;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Offset;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.OrderByElement;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectBody;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectItem;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Skip;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Top;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Wait;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PlainSelect
implements SelectBody {
    private Distinct distinct = null;
    private List<SelectItem> selectItems;
    private List<Table> intoTables;
    private FromItem fromItem;
    private List<Join> joins;
    private Expression where;
    private List<Expression> groupByColumnReferences;
    private List<OrderByElement> orderByElements;
    private Expression having;
    private Limit limit;
    private Offset offset;
    private Fetch fetch;
    private Skip skip;
    private First first;
    private Top top;
    private OracleHierarchicalExpression oracleHierarchical = null;
    private OracleHint oracleHint = null;
    private boolean oracleSiblings = false;
    private boolean forUpdate = false;
    private Table forUpdateTable = null;
    private boolean useBrackets = false;
    private Wait wait;

    public boolean isUseBrackets() {
        return this.useBrackets;
    }

    public void setUseBrackets(boolean bl) {
        this.useBrackets = bl;
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public List<Table> getIntoTables() {
        return this.intoTables;
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public void setIntoTables(List<Table> list) {
        this.intoTables = list;
    }

    public void setSelectItems(List<SelectItem> list) {
        this.selectItems = list;
    }

    public void addSelectItems(SelectItem ... selectItemArray) {
        if (this.selectItems == null) {
            this.selectItems = new ArrayList<SelectItem>();
        }
        Collections.addAll(this.selectItems, selectItemArray);
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> list) {
        this.joins = list;
    }

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> list) {
        this.orderByElements = list;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public Top getTop() {
        return this.top;
    }

    public void setTop(Top top) {
        this.top = top;
    }

    public Skip getSkip() {
        return this.skip;
    }

    public void setSkip(Skip skip) {
        this.skip = skip;
    }

    public First getFirst() {
        return this.first;
    }

    public void setFirst(First first) {
        this.first = first;
    }

    public Distinct getDistinct() {
        return this.distinct;
    }

    public void setDistinct(Distinct distinct) {
        this.distinct = distinct;
    }

    public Expression getHaving() {
        return this.having;
    }

    public void setHaving(Expression expression) {
        this.having = expression;
    }

    public List<Expression> getGroupByColumnReferences() {
        return this.groupByColumnReferences;
    }

    public void setGroupByColumnReferences(List<Expression> list) {
        this.groupByColumnReferences = list;
    }

    public void addGroupByColumnReference(Expression expression) {
        if (this.groupByColumnReferences == null) {
            this.groupByColumnReferences = new ArrayList<Expression>();
        }
        this.groupByColumnReferences.add(expression);
    }

    public OracleHierarchicalExpression getOracleHierarchical() {
        return this.oracleHierarchical;
    }

    public void setOracleHierarchical(OracleHierarchicalExpression oracleHierarchicalExpression) {
        this.oracleHierarchical = oracleHierarchicalExpression;
    }

    public boolean isOracleSiblings() {
        return this.oracleSiblings;
    }

    public void setOracleSiblings(boolean bl) {
        this.oracleSiblings = bl;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean bl) {
        this.forUpdate = bl;
    }

    public Table getForUpdateTable() {
        return this.forUpdateTable;
    }

    public void setForUpdateTable(Table table) {
        this.forUpdateTable = table;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public void setWait(Wait wait) {
        this.wait = wait;
    }

    public Wait getWait() {
        return this.wait;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.useBrackets) {
            stringBuilder.append("(");
        }
        stringBuilder.append("SELECT ");
        if (this.oracleHint != null) {
            stringBuilder.append(this.oracleHint).append(" ");
        }
        if (this.skip != null) {
            stringBuilder.append(this.skip).append(" ");
        }
        if (this.first != null) {
            stringBuilder.append(this.first).append(" ");
        }
        if (this.distinct != null) {
            stringBuilder.append(this.distinct).append(" ");
        }
        if (this.top != null) {
            stringBuilder.append(this.top).append(" ");
        }
        stringBuilder.append(PlainSelect.getStringList(this.selectItems));
        if (this.intoTables != null) {
            stringBuilder.append(" INTO ");
            Iterator<Object> iterator = this.intoTables.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
        }
        if (this.fromItem != null) {
            stringBuilder.append(" FROM ").append(this.fromItem);
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        stringBuilder.append(", ").append(join);
                        continue;
                    }
                    stringBuilder.append(" ").append(join);
                }
            }
            if (this.where != null) {
                stringBuilder.append(" WHERE ").append(this.where);
            }
            if (this.oracleHierarchical != null) {
                stringBuilder.append(this.oracleHierarchical.toString());
            }
            stringBuilder.append(PlainSelect.getFormatedList(this.groupByColumnReferences, "GROUP BY"));
            if (this.having != null) {
                stringBuilder.append(" HAVING ").append(this.having);
            }
            stringBuilder.append(PlainSelect.orderByToString(this.oracleSiblings, this.orderByElements));
            if (this.limit != null) {
                stringBuilder.append(this.limit);
            }
            if (this.offset != null) {
                stringBuilder.append(this.offset);
            }
            if (this.fetch != null) {
                stringBuilder.append(this.fetch);
            }
            if (this.isForUpdate()) {
                stringBuilder.append(" FOR UPDATE");
                if (this.forUpdateTable != null) {
                    stringBuilder.append(" OF ").append(this.forUpdateTable);
                }
                if (this.wait != null) {
                    stringBuilder.append(this.wait);
                }
            }
        } else if (this.where != null) {
            stringBuilder.append(" WHERE ").append(this.where);
        }
        if (this.useBrackets) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public static String orderByToString(List<OrderByElement> list) {
        return PlainSelect.orderByToString(false, list);
    }

    public static String orderByToString(boolean bl, List<OrderByElement> list) {
        return PlainSelect.getFormatedList(list, bl ? "ORDER SIBLINGS BY" : "ORDER BY");
    }

    public static String getFormatedList(List<?> list, String string) {
        return PlainSelect.getFormatedList(list, string, true, false);
    }

    public static String getFormatedList(List<?> list, String string, boolean bl, boolean bl2) {
        String string2 = PlainSelect.getStringList(list, bl, bl2);
        if (string2.length() > 0) {
            string2 = string.length() > 0 ? " " + string + " " + string2 : " " + string2;
        }
        return string2;
    }

    public static String getStringList(List<?> list) {
        return PlainSelect.getStringList(list, true, false);
    }

    public static String getStringList(List<?> list, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = ",";
        if (!bl) {
            string = "";
        }
        if (list != null) {
            if (bl2) {
                stringBuilder.append("(");
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                stringBuilder.append(list.get(i2)).append(i2 < list.size() - 1 ? string + " " : "");
            }
            if (bl2) {
                stringBuilder.append(")");
            }
        }
        return stringBuilder.toString();
    }
}

