/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.update;

import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.Expression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.schema.Column;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.schema.Table;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.Statement;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.StatementVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.FromItem;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Join;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Limit;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.OrderByElement;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.PlainSelect;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Select;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectExpressionItem;
import java.util.List;

public class Update
implements Statement {
    private List<Table> tables;
    private Expression where;
    private List<Column> columns;
    private List<Expression> expressions;
    private FromItem fromItem;
    private List<Join> joins;
    private Select select;
    private boolean useColumnsBrackets = true;
    private boolean useSelect = false;
    private List<OrderByElement> orderByElements;
    private Limit limit;
    private boolean returningAllColumns = false;
    private List<SelectExpressionItem> returningExpressionList = null;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setTables(List<Table> list) {
        this.tables = list;
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> list) {
        this.joins = list;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public boolean isUseColumnsBrackets() {
        return this.useColumnsBrackets;
    }

    public void setUseColumnsBrackets(boolean bl) {
        this.useColumnsBrackets = bl;
    }

    public boolean isUseSelect() {
        return this.useSelect;
    }

    public void setUseSelect(boolean bl) {
        this.useSelect = bl;
    }

    public void setOrderByElements(List<OrderByElement> list) {
        this.orderByElements = list;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public boolean isReturningAllColumns() {
        return this.returningAllColumns;
    }

    public void setReturningAllColumns(boolean bl) {
        this.returningAllColumns = bl;
    }

    public List<SelectExpressionItem> getReturningExpressionList() {
        return this.returningExpressionList;
    }

    public void setReturningExpressionList(List<SelectExpressionItem> list) {
        this.returningExpressionList = list;
    }

    public String toString() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder("UPDATE ");
        stringBuilder.append(PlainSelect.getStringList(this.getTables(), true, false)).append(" SET ");
        if (!this.useSelect) {
            for (n2 = 0; n2 < this.getColumns().size(); ++n2) {
                if (n2 != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.columns.get(n2)).append(" = ");
                stringBuilder.append(this.expressions.get(n2));
            }
        } else {
            if (this.useColumnsBrackets) {
                stringBuilder.append("(");
            }
            for (n2 = 0; n2 < this.getColumns().size(); ++n2) {
                if (n2 != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.columns.get(n2));
            }
            if (this.useColumnsBrackets) {
                stringBuilder.append(")");
            }
            stringBuilder.append(" = ");
            stringBuilder.append("(").append(this.select).append(")");
        }
        if (this.fromItem != null) {
            stringBuilder.append(" FROM ").append(this.fromItem);
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        stringBuilder.append(", ").append(join);
                        continue;
                    }
                    stringBuilder.append(" ").append(join);
                }
            }
        }
        if (this.where != null) {
            stringBuilder.append(" WHERE ");
            stringBuilder.append(this.where);
        }
        if (this.orderByElements != null) {
            stringBuilder.append(PlainSelect.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            stringBuilder.append(this.limit);
        }
        if (this.isReturningAllColumns()) {
            stringBuilder.append(" RETURNING *");
        } else if (this.getReturningExpressionList() != null) {
            stringBuilder.append(" RETURNING ").append(PlainSelect.getStringList(this.getReturningExpressionList(), true, false));
        }
        return stringBuilder.toString();
    }
}

