/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.net.sf.jsqlparser.util;

import com.contrastsecurity.thirdparty.net.sf.jsqlparser.JSQLParserException;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.Expression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.schema.Table;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.AllColumns;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Join;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.PlainSelect;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Select;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectExpressionItem;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectItem;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SetOperationList;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.WithItem;
import java.util.ArrayList;
import java.util.List;

public final class SelectUtils {
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";

    private SelectUtils() {
    }

    public static Select buildSelectFromTableAndExpressions(Table table, Expression ... expressionArray) {
        SelectItem[] selectItemArray = new SelectItem[expressionArray.length];
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            selectItemArray[i2] = new SelectExpressionItem(expressionArray[i2]);
        }
        return SelectUtils.buildSelectFromTableAndSelectItems(table, selectItemArray);
    }

    public static Select buildSelectFromTableAndExpressions(Table table, String ... stringArray) throws JSQLParserException {
        SelectItem[] selectItemArray = new SelectItem[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            selectItemArray[i2] = new SelectExpressionItem(CCJSqlParserUtil.parseExpression(stringArray[i2]));
        }
        return SelectUtils.buildSelectFromTableAndSelectItems(table, selectItemArray);
    }

    public static Select buildSelectFromTableAndSelectItems(Table table, SelectItem ... selectItemArray) {
        Select select = new Select();
        PlainSelect plainSelect = new PlainSelect();
        plainSelect.addSelectItems(selectItemArray);
        plainSelect.setFromItem(table);
        select.setSelectBody(plainSelect);
        return select;
    }

    public static Select buildSelectFromTable(Table table) {
        return SelectUtils.buildSelectFromTableAndSelectItems(table, new AllColumns());
    }

    public static void addExpression(Select select, final Expression expression) {
        select.getSelectBody().accept(new SelectVisitor(){

            @Override
            public void visit(PlainSelect plainSelect) {
                plainSelect.getSelectItems().add(new SelectExpressionItem(expression));
            }

            @Override
            public void visit(SetOperationList setOperationList) {
                throw new UnsupportedOperationException(SelectUtils.NOT_SUPPORTED_YET);
            }

            @Override
            public void visit(WithItem withItem) {
                throw new UnsupportedOperationException(SelectUtils.NOT_SUPPORTED_YET);
            }
        });
    }

    public static Join addJoin(Select select, Table table, Expression expression) {
        if (select.getSelectBody() instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
            List<Join> list = plainSelect.getJoins();
            if (list == null) {
                list = new ArrayList<Join>();
                plainSelect.setJoins(list);
            }
            Join join = new Join();
            join.setRightItem(table);
            join.setOnExpression(expression);
            list.add(join);
            return join;
        }
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public static void addGroupBy(Select select, final Expression expression) {
        select.getSelectBody().accept(new SelectVisitor(){

            @Override
            public void visit(PlainSelect plainSelect) {
                plainSelect.addGroupByColumnReference(expression);
            }

            @Override
            public void visit(SetOperationList setOperationList) {
                throw new UnsupportedOperationException(SelectUtils.NOT_SUPPORTED_YET);
            }

            @Override
            public void visit(WithItem withItem) {
                throw new UnsupportedOperationException(SelectUtils.NOT_SUPPORTED_YET);
            }
        });
    }
}

