/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.net.sf.jsqlparser.util.deparser;

import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.Alias;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.Expression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.ExpressionVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.MySQLIndexHint;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.OracleHint;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.schema.Column;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.schema.Table;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.AllColumns;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.AllTableColumns;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Fetch;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.First;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.FromItem;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.FromItemVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Join;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.LateralSubSelect;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Offset;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Pivot;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.PivotVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.PivotXml;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.PlainSelect;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectExpressionItem;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectItem;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectItemVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SetOperationList;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Skip;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SubJoin;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SubSelect;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.TableFunction;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.ValuesList;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.WithItem;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.util.deparser.LimitDeparser;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.util.deparser.OrderByDeParser;
import java.util.Iterator;
import java.util.List;

public class SelectDeParser
implements FromItemVisitor,
PivotVisitor,
SelectItemVisitor,
SelectVisitor {
    private StringBuilder buffer = new StringBuilder();
    private ExpressionVisitor expressionVisitor = new ExpressionVisitorAdapter();

    public SelectDeParser() {
    }

    public SelectDeParser(ExpressionVisitor expressionVisitor, StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        Iterator<Expression> iterator;
        Object object2;
        First first;
        Skip skip;
        if (plainSelect.isUseBrackets()) {
            this.buffer.append("(");
        }
        this.buffer.append("SELECT ");
        OracleHint oracleHint = plainSelect.getOracleHint();
        if (oracleHint != null) {
            this.buffer.append(oracleHint).append(" ");
        }
        if ((skip = plainSelect.getSkip()) != null) {
            this.buffer.append(skip).append(" ");
        }
        if ((first = plainSelect.getFirst()) != null) {
            this.buffer.append(first).append(" ");
        }
        if (plainSelect.getDistinct() != null) {
            if (plainSelect.getDistinct().isUseUnique()) {
                this.buffer.append("UNIQUE ");
            } else {
                this.buffer.append("DISTINCT ");
            }
            if (plainSelect.getDistinct().getOnSelectItems() != null) {
                this.buffer.append("ON (");
                object2 = plainSelect.getDistinct().getOnSelectItems().iterator();
                while (object2.hasNext()) {
                    iterator = (SelectItem)object2.next();
                    iterator.accept(this);
                    if (!object2.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(") ");
            }
        }
        if ((object2 = plainSelect.getTop()) != null) {
            this.buffer.append(object2).append(" ");
        }
        iterator = plainSelect.getSelectItems().iterator();
        while (iterator.hasNext()) {
            SelectItem object3 = iterator.next();
            object3.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        if (plainSelect.getIntoTables() != null) {
            this.buffer.append(" INTO ");
            iterator = plainSelect.getIntoTables().iterator();
            while (iterator.hasNext()) {
                this.visit((Table)iterator.next());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        if (plainSelect.getFromItem() != null) {
            this.buffer.append(" FROM ");
            plainSelect.getFromItem().accept(this);
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                this.deparseJoin(join);
            }
        }
        if (plainSelect.getWhere() != null) {
            this.buffer.append(" WHERE ");
            plainSelect.getWhere().accept(this.expressionVisitor);
        }
        if (plainSelect.getOracleHierarchical() != null) {
            plainSelect.getOracleHierarchical().accept(this.expressionVisitor);
        }
        if (plainSelect.getGroupByColumnReferences() != null) {
            this.buffer.append(" GROUP BY ");
            iterator = plainSelect.getGroupByColumnReferences().iterator();
            while (iterator.hasNext()) {
                Expression expression = iterator.next();
                expression.accept(this.expressionVisitor);
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        if (plainSelect.getHaving() != null) {
            this.buffer.append(" HAVING ");
            plainSelect.getHaving().accept(this.expressionVisitor);
        }
        if (plainSelect.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(plainSelect.isOracleSiblings(), plainSelect.getOrderByElements());
        }
        if (plainSelect.getLimit() != null) {
            new LimitDeparser(this.buffer).deParse(plainSelect.getLimit());
        }
        if (plainSelect.getOffset() != null) {
            this.deparseOffset(plainSelect.getOffset());
        }
        if (plainSelect.getFetch() != null) {
            this.deparseFetch(plainSelect.getFetch());
        }
        if (plainSelect.isForUpdate()) {
            this.buffer.append(" FOR UPDATE");
            if (plainSelect.getForUpdateTable() != null) {
                this.buffer.append(" OF ").append(plainSelect.getForUpdateTable());
            }
            if (plainSelect.getWait() != null) {
                this.buffer.append(plainSelect.getWait());
            }
        }
        if (plainSelect.isUseBrackets()) {
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
        this.buffer.append(allTableColumns.getTable().getFullyQualifiedName()).append(".*");
    }

    @Override
    public void visit(SelectExpressionItem selectExpressionItem) {
        selectExpressionItem.getExpression().accept(this.expressionVisitor);
        if (selectExpressionItem.getAlias() != null) {
            this.buffer.append(selectExpressionItem.getAlias().toString());
        }
    }

    @Override
    public void visit(SubSelect subSelect) {
        Object object;
        Object object2;
        this.buffer.append("(");
        if (subSelect.getWithItemsList() != null && !subSelect.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            object2 = subSelect.getWithItemsList().iterator();
            while (object2.hasNext()) {
                object = (WithItem)object2.next();
                ((WithItem)object).accept(this);
                if (object2.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        subSelect.getSelectBody().accept(this);
        this.buffer.append(")");
        object2 = subSelect.getPivot();
        if (object2 != null) {
            ((Pivot)object2).accept(this);
        }
        if ((object = subSelect.getAlias()) != null) {
            this.buffer.append(((Alias)object).toString());
        }
    }

    @Override
    public void visit(Table table) {
        MySQLIndexHint mySQLIndexHint;
        Alias alias;
        this.buffer.append(table.getFullyQualifiedName());
        Pivot pivot = table.getPivot();
        if (pivot != null) {
            pivot.accept(this);
        }
        if ((alias = table.getAlias()) != null) {
            this.buffer.append(alias);
        }
        if ((mySQLIndexHint = table.getIndexHint()) != null) {
            this.buffer.append(mySQLIndexHint);
        }
    }

    @Override
    public void visit(Pivot pivot) {
        List<Column> list = pivot.getForColumns();
        this.buffer.append(" PIVOT (").append(PlainSelect.getStringList(pivot.getFunctionItems())).append(" FOR ").append(PlainSelect.getStringList(list, true, list != null && list.size() > 1)).append(" IN ").append(PlainSelect.getStringList(pivot.getInItems(), true, true)).append(")");
    }

    @Override
    public void visit(PivotXml pivotXml) {
        List<Column> list = pivotXml.getForColumns();
        this.buffer.append(" PIVOT XML (").append(PlainSelect.getStringList(pivotXml.getFunctionItems())).append(" FOR ").append(PlainSelect.getStringList(list, true, list != null && list.size() > 1)).append(" IN (");
        if (pivotXml.isInAny()) {
            this.buffer.append("ANY");
        } else if (pivotXml.getInSelect() != null) {
            this.buffer.append(pivotXml.getInSelect());
        } else {
            this.buffer.append(PlainSelect.getStringList(pivotXml.getInItems()));
        }
        this.buffer.append("))");
    }

    public void deparseOffset(Offset offset) {
        if (offset.isOffsetJdbcParameter()) {
            this.buffer.append(" OFFSET ?");
        } else if (offset.getOffset() != 0L) {
            this.buffer.append(" OFFSET ");
            this.buffer.append(offset.getOffset());
        }
        if (offset.getOffsetParam() != null) {
            this.buffer.append(" ").append(offset.getOffsetParam());
        }
    }

    public void deparseFetch(Fetch fetch) {
        this.buffer.append(" FETCH ");
        if (fetch.isFetchParamFirst()) {
            this.buffer.append("FIRST ");
        } else {
            this.buffer.append("NEXT ");
        }
        if (fetch.isFetchJdbcParameter()) {
            this.buffer.append("?");
        } else {
            this.buffer.append(fetch.getRowCount());
        }
        this.buffer.append(" ").append(fetch.getFetchParam()).append(" ONLY");
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void visit(SubJoin subJoin) {
        this.buffer.append("(");
        subJoin.getLeft().accept(this);
        this.deparseJoin(subJoin.getJoin());
        this.buffer.append(")");
        if (subJoin.getPivot() != null) {
            subJoin.getPivot().accept(this);
        }
    }

    public void deparseJoin(Join join) {
        if (join.isSimple()) {
            this.buffer.append(", ");
        } else {
            if (join.isRight()) {
                this.buffer.append(" RIGHT");
            } else if (join.isNatural()) {
                this.buffer.append(" NATURAL");
            } else if (join.isFull()) {
                this.buffer.append(" FULL");
            } else if (join.isLeft()) {
                this.buffer.append(" LEFT");
            } else if (join.isCross()) {
                this.buffer.append(" CROSS");
            }
            if (join.isOuter()) {
                this.buffer.append(" OUTER");
            } else if (join.isInner()) {
                this.buffer.append(" INNER");
            } else if (join.isSemi()) {
                this.buffer.append(" SEMI");
            }
            this.buffer.append(" JOIN ");
        }
        FromItem fromItem = join.getRightItem();
        fromItem.accept(this);
        if (join.getOnExpression() != null) {
            this.buffer.append(" ON ");
            join.getOnExpression().accept(this.expressionVisitor);
        }
        if (join.getUsingColumns() != null) {
            this.buffer.append(" USING (");
            Iterator<Column> iterator = join.getUsingColumns().iterator();
            while (iterator.hasNext()) {
                Column column = iterator.next();
                this.buffer.append(column.toString());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(SetOperationList setOperationList) {
        for (int i2 = 0; i2 < setOperationList.getSelects().size(); ++i2) {
            boolean bl;
            if (i2 != 0) {
                this.buffer.append(' ').append(setOperationList.getOperations().get(i2 - 1)).append(' ');
            }
            boolean bl2 = bl = setOperationList.getBrackets() == null || setOperationList.getBrackets().get(i2) != false;
            if (bl) {
                this.buffer.append("(");
            }
            setOperationList.getSelects().get(i2).accept(this);
            if (!bl) continue;
            this.buffer.append(")");
        }
        if (setOperationList.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(setOperationList.getOrderByElements());
        }
        if (setOperationList.getLimit() != null) {
            new LimitDeparser(this.buffer).deParse(setOperationList.getLimit());
        }
        if (setOperationList.getOffset() != null) {
            this.deparseOffset(setOperationList.getOffset());
        }
        if (setOperationList.getFetch() != null) {
            this.deparseFetch(setOperationList.getFetch());
        }
    }

    @Override
    public void visit(WithItem withItem) {
        if (withItem.isRecursive()) {
            this.buffer.append("RECURSIVE ");
        }
        this.buffer.append(withItem.getName());
        if (withItem.getWithItemList() != null) {
            this.buffer.append(" ").append(PlainSelect.getStringList(withItem.getWithItemList(), true, true));
        }
        this.buffer.append(" AS (");
        withItem.getSelectBody().accept(this);
        this.buffer.append(")");
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
        this.buffer.append(lateralSubSelect.toString());
    }

    @Override
    public void visit(ValuesList valuesList) {
        this.buffer.append(valuesList.toString());
    }

    @Override
    public void visit(AllColumns allColumns) {
        this.buffer.append('*');
    }

    @Override
    public void visit(TableFunction tableFunction) {
        this.buffer.append(tableFunction.toString());
    }
}

