/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.io.filefilter;

import com.contrastsecurity.thirdparty.org.apache.commons.io.FileUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.io.filefilter.AbstractFileFilter;
import java.io.File;
import java.io.Serializable;
import java.util.Date;

public class AgeFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = -2132740084016138541L;
    private final long cutoff;
    private final boolean acceptOlder;

    public AgeFileFilter(long l2) {
        this(l2, true);
    }

    public AgeFileFilter(long l2, boolean bl) {
        this.acceptOlder = bl;
        this.cutoff = l2;
    }

    public AgeFileFilter(Date date) {
        this(date, true);
    }

    public AgeFileFilter(Date date, boolean bl) {
        this(date.getTime(), bl);
    }

    public AgeFileFilter(File file) {
        this(file, true);
    }

    public AgeFileFilter(File file, boolean bl) {
        this(file.lastModified(), bl);
    }

    @Override
    public boolean accept(File file) {
        boolean bl = FileUtils.isFileNewer(file, this.cutoff);
        return this.acceptOlder ? !bl : bl;
    }

    @Override
    public String toString() {
        String string = this.acceptOlder ? "<=" : ">";
        return super.toString() + "(" + string + this.cutoff + ")";
    }
}

