/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.io.filefilter;

import com.contrastsecurity.thirdparty.org.apache.commons.io.filefilter.AbstractFileFilter;
import java.io.File;
import java.io.Serializable;

public class SizeFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = 7388077430788600069L;
    private final long size;
    private final boolean acceptLarger;

    public SizeFileFilter(long l2) {
        this(l2, true);
    }

    public SizeFileFilter(long l2, boolean bl) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("The size must be non-negative");
        }
        this.size = l2;
        this.acceptLarger = bl;
    }

    @Override
    public boolean accept(File file) {
        boolean bl;
        boolean bl2 = bl = file.length() < this.size;
        return this.acceptLarger ? !bl : bl;
    }

    @Override
    public String toString() {
        String string = this.acceptLarger ? ">=" : "<";
        return super.toString() + "(" + string + this.size + ")";
    }
}

