/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.io.output;

import com.contrastsecurity.thirdparty.org.apache.commons.io.output.ProxyOutputStream;
import java.io.OutputStream;

public class CountingOutputStream
extends ProxyOutputStream {
    private long count = 0L;

    public CountingOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    protected synchronized void beforeWrite(int n2) {
        this.count += (long)n2;
    }

    public int getCount() {
        long l2 = this.getByteCount();
        if (l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + l2 + " is too large to be converted to an int");
        }
        return (int)l2;
    }

    public int resetCount() {
        long l2 = this.resetByteCount();
        if (l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + l2 + " is too large to be converted to an int");
        }
        return (int)l2;
    }

    public synchronized long getByteCount() {
        return this.count;
    }

    public synchronized long resetByteCount() {
        long l2 = this.count;
        this.count = 0L;
        return l2;
    }
}

