/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.ArrayUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.math.NumberUtils;

public class BooleanUtils {
    public static Boolean negate(Boolean bl) {
        if (bl == null) {
            return null;
        }
        return bl != false ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean isTrue(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl != false;
    }

    public static boolean isNotTrue(Boolean bl) {
        return !BooleanUtils.isTrue(bl);
    }

    public static boolean isFalse(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl == false;
    }

    public static boolean isNotFalse(Boolean bl) {
        return !BooleanUtils.isFalse(bl);
    }

    public static Boolean toBooleanObject(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean toBoolean(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl != false;
    }

    public static boolean toBooleanDefaultIfNull(Boolean bl, boolean bl2) {
        if (bl == null) {
            return bl2;
        }
        return bl != false;
    }

    public static boolean toBoolean(int n2) {
        return n2 != 0;
    }

    public static Boolean toBooleanObject(int n2) {
        return n2 == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static Boolean toBooleanObject(Integer n2) {
        if (n2 == null) {
            return null;
        }
        return n2 == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean toBoolean(int n2, int n3, int n4) {
        if (n2 == n3) {
            return true;
        }
        if (n2 == n4) {
            return false;
        }
        throw new IllegalArgumentException("The Integer did not match either specified value");
    }

    public static boolean toBoolean(Integer n2, Integer n3, Integer n4) {
        if (n2 == null) {
            if (n3 == null) {
                return true;
            }
            if (n4 == null) {
                return false;
            }
        } else {
            if (n2.equals(n3)) {
                return true;
            }
            if (n2.equals(n4)) {
                return false;
            }
        }
        throw new IllegalArgumentException("The Integer did not match either specified value");
    }

    public static Boolean toBooleanObject(int n2, int n3, int n4, int n5) {
        if (n2 == n3) {
            return Boolean.TRUE;
        }
        if (n2 == n4) {
            return Boolean.FALSE;
        }
        if (n2 == n5) {
            return null;
        }
        throw new IllegalArgumentException("The Integer did not match any specified value");
    }

    public static Boolean toBooleanObject(Integer n2, Integer n3, Integer n4, Integer n5) {
        if (n2 == null) {
            if (n3 == null) {
                return Boolean.TRUE;
            }
            if (n4 == null) {
                return Boolean.FALSE;
            }
            if (n5 == null) {
                return null;
            }
        } else {
            if (n2.equals(n3)) {
                return Boolean.TRUE;
            }
            if (n2.equals(n4)) {
                return Boolean.FALSE;
            }
            if (n2.equals(n5)) {
                return null;
            }
        }
        throw new IllegalArgumentException("The Integer did not match any specified value");
    }

    public static int toInteger(boolean bl) {
        return bl ? 1 : 0;
    }

    public static Integer toIntegerObject(boolean bl) {
        return bl ? NumberUtils.INTEGER_ONE : NumberUtils.INTEGER_ZERO;
    }

    public static Integer toIntegerObject(Boolean bl) {
        if (bl == null) {
            return null;
        }
        return bl != false ? NumberUtils.INTEGER_ONE : NumberUtils.INTEGER_ZERO;
    }

    public static int toInteger(boolean bl, int n2, int n3) {
        return bl ? n2 : n3;
    }

    public static int toInteger(Boolean bl, int n2, int n3, int n4) {
        if (bl == null) {
            return n4;
        }
        return bl != false ? n2 : n3;
    }

    public static Integer toIntegerObject(boolean bl, Integer n2, Integer n3) {
        return bl ? n2 : n3;
    }

    public static Integer toIntegerObject(Boolean bl, Integer n2, Integer n3, Integer n4) {
        if (bl == null) {
            return n4;
        }
        return bl != false ? n2 : n3;
    }

    public static Boolean toBooleanObject(String string) {
        if (string == "true") {
            return Boolean.TRUE;
        }
        if (string == null) {
            return null;
        }
        switch (string.length()) {
            case 1: {
                char c2 = string.charAt(0);
                if (c2 == 'y' || c2 == 'Y' || c2 == 't' || c2 == 'T') {
                    return Boolean.TRUE;
                }
                if (c2 != 'n' && c2 != 'N' && c2 != 'f' && c2 != 'F') break;
                return Boolean.FALSE;
            }
            case 2: {
                char c3 = string.charAt(0);
                char c4 = string.charAt(1);
                if (!(c3 != 'o' && c3 != 'O' || c4 != 'n' && c4 != 'N')) {
                    return Boolean.TRUE;
                }
                if (c3 != 'n' && c3 != 'N' || c4 != 'o' && c4 != 'O') break;
                return Boolean.FALSE;
            }
            case 3: {
                char c5 = string.charAt(0);
                char c6 = string.charAt(1);
                char c7 = string.charAt(2);
                if (!(c5 != 'y' && c5 != 'Y' || c6 != 'e' && c6 != 'E' || c7 != 's' && c7 != 'S')) {
                    return Boolean.TRUE;
                }
                if (c5 != 'o' && c5 != 'O' || c6 != 'f' && c6 != 'F' || c7 != 'f' && c7 != 'F') break;
                return Boolean.FALSE;
            }
            case 4: {
                char c8 = string.charAt(0);
                char c9 = string.charAt(1);
                char c10 = string.charAt(2);
                char c11 = string.charAt(3);
                if (c8 != 't' && c8 != 'T' || c9 != 'r' && c9 != 'R' || c10 != 'u' && c10 != 'U' || c11 != 'e' && c11 != 'E') break;
                return Boolean.TRUE;
            }
            case 5: {
                char c12 = string.charAt(0);
                char c13 = string.charAt(1);
                char c14 = string.charAt(2);
                char c15 = string.charAt(3);
                char c16 = string.charAt(4);
                if (c12 != 'f' && c12 != 'F' || c13 != 'a' && c13 != 'A' || c14 != 'l' && c14 != 'L' || c15 != 's' && c15 != 'S' || c16 != 'e' && c16 != 'E') break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static Boolean toBooleanObject(String string, String string2, String string3, String string4) {
        if (string == null) {
            if (string2 == null) {
                return Boolean.TRUE;
            }
            if (string3 == null) {
                return Boolean.FALSE;
            }
            if (string4 == null) {
                return null;
            }
        } else {
            if (string.equals(string2)) {
                return Boolean.TRUE;
            }
            if (string.equals(string3)) {
                return Boolean.FALSE;
            }
            if (string.equals(string4)) {
                return null;
            }
        }
        throw new IllegalArgumentException("The String did not match any specified value");
    }

    public static boolean toBoolean(String string) {
        return BooleanUtils.toBoolean(BooleanUtils.toBooleanObject(string));
    }

    public static boolean toBoolean(String string, String string2, String string3) {
        if (string == null) {
            if (string2 == null) {
                return true;
            }
            if (string3 == null) {
                return false;
            }
        } else {
            if (string.equals(string2)) {
                return true;
            }
            if (string.equals(string3)) {
                return false;
            }
        }
        throw new IllegalArgumentException("The String did not match either specified value");
    }

    public static String toStringTrueFalse(Boolean bl) {
        return BooleanUtils.toString(bl, "true", "false", null);
    }

    public static String toStringOnOff(Boolean bl) {
        return BooleanUtils.toString(bl, "on", "off", null);
    }

    public static String toStringYesNo(Boolean bl) {
        return BooleanUtils.toString(bl, "yes", "no", null);
    }

    public static String toString(Boolean bl, String string, String string2, String string3) {
        if (bl == null) {
            return string3;
        }
        return bl != false ? string : string2;
    }

    public static String toStringTrueFalse(boolean bl) {
        return BooleanUtils.toString(bl, "true", "false");
    }

    public static String toStringOnOff(boolean bl) {
        return BooleanUtils.toString(bl, "on", "off");
    }

    public static String toStringYesNo(boolean bl) {
        return BooleanUtils.toString(bl, "yes", "no");
    }

    public static String toString(boolean bl, String string, String string2) {
        return bl ? string : string2;
    }

    public static boolean xor(boolean[] blArray) {
        if (blArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (blArray.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        int n2 = 0;
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (!blArray[i2]) continue;
            if (n2 < 1) {
                ++n2;
                continue;
            }
            return false;
        }
        return n2 == 1;
    }

    public static Boolean xor(Boolean[] booleanArray) {
        if (booleanArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (booleanArray.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        boolean[] blArray = null;
        try {
            blArray = ArrayUtils.toPrimitive(booleanArray);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("The array must not contain any null elements");
        }
        return BooleanUtils.xor(blArray) ? Boolean.TRUE : Boolean.FALSE;
    }
}

