/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.impl.client;

import com.contrastsecurity.thirdparty.org.apache.http.HttpEntity;
import com.contrastsecurity.thirdparty.org.apache.http.HttpResponse;
import com.contrastsecurity.thirdparty.org.apache.http.StatusLine;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.Contract;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.org.apache.http.client.HttpResponseException;
import com.contrastsecurity.thirdparty.org.apache.http.client.ResponseHandler;
import com.contrastsecurity.thirdparty.org.apache.http.util.EntityUtils;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse httpResponse) throws HttpResponseException, IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        HttpEntity httpEntity = httpResponse.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(httpEntity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return httpEntity == null ? null : (T)this.handleEntity(httpEntity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

