/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.impl.client;

import com.contrastsecurity.thirdparty.org.apache.http.HttpResponse;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.Contract;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.org.apache.http.client.ServiceUnavailableRetryStrategy;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private final int maxRetries;
    private final long retryInterval;

    public DefaultServiceUnavailableRetryStrategy(int n2, int n3) {
        Args.positive(n2, "Max retries");
        Args.positive(n3, "Retry interval");
        this.maxRetries = n2;
        this.retryInterval = n3;
    }

    public DefaultServiceUnavailableRetryStrategy() {
        this(1, 1000);
    }

    @Override
    public boolean retryRequest(HttpResponse httpResponse, int n2, HttpContext httpContext) {
        return n2 <= this.maxRetries && httpResponse.getStatusLine().getStatusCode() == 503;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }
}

