/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.impl.cookie;

import com.contrastsecurity.thirdparty.org.apache.http.annotation.Contract;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.org.apache.http.cookie.CommonCookieAttributeHandler;
import com.contrastsecurity.thirdparty.org.apache.http.cookie.Cookie;
import com.contrastsecurity.thirdparty.org.apache.http.cookie.CookieOrigin;
import com.contrastsecurity.thirdparty.org.apache.http.cookie.MalformedCookieException;
import com.contrastsecurity.thirdparty.org.apache.http.cookie.SetCookie;
import com.contrastsecurity.thirdparty.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.contrastsecurity.thirdparty.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        setCookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        return !cookie.isSecure() || cookieOrigin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

