/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.impl.io;

import com.contrastsecurity.thirdparty.org.apache.http.io.SessionOutputBuffer;
import com.contrastsecurity.thirdparty.org.apache.http.util.Args;
import java.io.IOException;
import java.io.OutputStream;

public class ContentLengthOutputStream
extends OutputStream {
    private final SessionOutputBuffer out;
    private final long contentLength;
    private long total;
    private boolean closed;

    public ContentLengthOutputStream(SessionOutputBuffer sessionOutputBuffer, long l2) {
        this.out = Args.notNull(sessionOutputBuffer, "Session output buffer");
        this.contentLength = Args.notNegative(l2, "Content length");
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.out.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        if (this.total < this.contentLength) {
            int n4 = n3;
            long l2 = this.contentLength - this.total;
            if ((long)n4 > l2) {
                n4 = (int)l2;
            }
            this.out.write(byArray, n2, n4);
            this.total += (long)n4;
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        if (this.total < this.contentLength) {
            this.out.write(n2);
            ++this.total;
        }
    }
}

