/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j;

import com.contrastsecurity.thirdparty.org.apache.log4j.Appender;
import com.contrastsecurity.thirdparty.org.apache.log4j.AppenderSkeleton;
import com.contrastsecurity.thirdparty.org.apache.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.AppenderAttachableImpl;
import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.LogLog;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.AppenderAttachable;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggingEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AsyncAppender
extends AppenderSkeleton
implements AppenderAttachable {
    public static final int DEFAULT_BUFFER_SIZE = 128;
    private final List buffer = new ArrayList();
    private final Map discardMap = new HashMap();
    private int bufferSize = 128;
    AppenderAttachableImpl aai = this.appenders = new AppenderAttachableImpl();
    private final AppenderAttachableImpl appenders;
    private final Thread dispatcher = new Thread(new Dispatcher(this, this.buffer, this.discardMap, this.appenders));
    private boolean locationInfo = false;
    private boolean blocking = true;

    public AsyncAppender() {
        this.dispatcher.setDaemon(true);
        this.dispatcher.setName("AsyncAppender-Dispatcher-" + this.dispatcher.getName());
        this.dispatcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.addAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LoggingEvent loggingEvent) {
        if (this.dispatcher == null || !this.dispatcher.isAlive() || this.bufferSize <= 0) {
            AppenderAttachableImpl appenderAttachableImpl = this.appenders;
            synchronized (appenderAttachableImpl) {
                this.appenders.appendLoopOnAppenders(loggingEvent);
            }
            return;
        }
        loggingEvent.getNDC();
        loggingEvent.getThreadName();
        loggingEvent.getMDCCopy();
        if (this.locationInfo) {
            loggingEvent.getLocationInformation();
        }
        loggingEvent.getRenderedMessage();
        loggingEvent.getThrowableStrRep();
        List list = this.buffer;
        synchronized (list) {
            block15: {
                boolean bl;
                do {
                    int n2;
                    if ((n2 = this.buffer.size()) < this.bufferSize) {
                        this.buffer.add(loggingEvent);
                        if (n2 == 0) {
                            this.buffer.notifyAll();
                        }
                        break block15;
                    }
                    bl = true;
                    if (!this.blocking || Thread.interrupted() || Thread.currentThread() == this.dispatcher) continue;
                    try {
                        this.buffer.wait();
                        bl = false;
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                } while (!bl);
                String string = loggingEvent.getLoggerName();
                DiscardSummary discardSummary = (DiscardSummary)this.discardMap.get(string);
                if (discardSummary == null) {
                    discardSummary = new DiscardSummary(loggingEvent);
                    this.discardMap.put(string, discardSummary);
                } else {
                    discardSummary.add(loggingEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.buffer;
        synchronized (object) {
            this.closed = true;
            this.buffer.notifyAll();
        }
        try {
            this.dispatcher.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            LogLog.error("Got an InterruptedException while waiting for the dispatcher to finish.", interruptedException);
        }
        object = this.appenders;
        synchronized (object) {
            Enumeration enumeration = this.appenders.getAllAppenders();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    Object e2 = enumeration.nextElement();
                    if (!(e2 instanceof Appender)) continue;
                    ((Appender)e2).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            return this.appenders.getAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Appender getAppender(String string) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            return this.appenders.getAppender(string);
        }
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttached(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            return this.appenders.isAttached(appender);
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(String string) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAppender(string);
        }
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferSize(int n2) {
        if (n2 < 0) {
            throw new NegativeArraySizeException("size");
        }
        List list = this.buffer;
        synchronized (list) {
            this.bufferSize = n2 < 1 ? 1 : n2;
            this.buffer.notifyAll();
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlocking(boolean bl) {
        List list = this.buffer;
        synchronized (list) {
            this.blocking = bl;
            this.buffer.notifyAll();
        }
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    private static class Dispatcher
    implements Runnable {
        private final AsyncAppender parent;
        private final List buffer;
        private final Map discardMap;
        private final AppenderAttachableImpl appenders;

        public Dispatcher(AsyncAppender asyncAppender, List list, Map map, AppenderAttachableImpl appenderAttachableImpl) {
            this.parent = asyncAppender;
            this.buffer = list;
            this.appenders = appenderAttachableImpl;
            this.discardMap = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = true;
            try {
                while (bl) {
                    LoggingEvent[] loggingEventArray = null;
                    List list = this.buffer;
                    synchronized (list) {
                        int n2 = this.buffer.size();
                        boolean bl2 = bl = !this.parent.closed;
                        while (n2 == 0 && bl) {
                            this.buffer.wait();
                            n2 = this.buffer.size();
                            bl = !this.parent.closed;
                        }
                        if (n2 > 0) {
                            loggingEventArray = new LoggingEvent[n2 + this.discardMap.size()];
                            this.buffer.toArray(loggingEventArray);
                            int n3 = n2;
                            Iterator iterator = this.discardMap.values().iterator();
                            while (iterator.hasNext()) {
                                loggingEventArray[n3++] = ((DiscardSummary)iterator.next()).createEvent();
                            }
                            this.buffer.clear();
                            this.discardMap.clear();
                            this.buffer.notifyAll();
                        }
                    }
                    if (loggingEventArray == null) continue;
                    for (int i2 = 0; i2 < loggingEventArray.length; ++i2) {
                        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
                        synchronized (appenderAttachableImpl) {
                            this.appenders.appendLoopOnAppenders(loggingEventArray[i2]);
                            continue;
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class DiscardSummary {
        private LoggingEvent maxEvent;
        private int count;

        public DiscardSummary(LoggingEvent loggingEvent) {
            this.maxEvent = loggingEvent;
            this.count = 1;
        }

        public void add(LoggingEvent loggingEvent) {
            if (loggingEvent.getLevel().toInt() > this.maxEvent.getLevel().toInt()) {
                this.maxEvent = loggingEvent;
            }
            ++this.count;
        }

        public LoggingEvent createEvent() {
            String string = MessageFormat.format("Discarded {0} messages due to full event buffer including: {1}", new Integer(this.count), this.maxEvent.getMessage());
            return new LoggingEvent("com.contrastsecurity.thirdparty.org.apache.log4j.AsyncAppender.DONT_REPORT_LOCATION", Logger.getLogger(this.maxEvent.getLoggerName()), this.maxEvent.getLevel(), string, null);
        }
    }
}

