/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j;

import com.contrastsecurity.thirdparty.org.apache.log4j.DefaultThrowableRenderer;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.ThrowableRenderer;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;

public final class EnhancedThrowableRenderer
implements ThrowableRenderer {
    private Method getStackTraceMethod;
    private Method getClassNameMethod;

    public EnhancedThrowableRenderer() {
        try {
            Class<?>[] classArray = null;
            this.getStackTraceMethod = Throwable.class.getMethod("getStackTrace", classArray);
            Class<?> clazz = Class.forName("java.lang.StackTraceElement");
            this.getClassNameMethod = clazz.getMethod("getClassName", classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] doRender(Throwable throwable) {
        if (this.getStackTraceMethod != null) {
            try {
                Object[] objectArray = null;
                Object[] objectArray2 = (Object[])this.getStackTraceMethod.invoke((Object)throwable, objectArray);
                String[] stringArray = new String[objectArray2.length + 1];
                stringArray[0] = throwable.toString();
                HashMap hashMap = new HashMap();
                for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                    stringArray[i2 + 1] = this.formatElement(objectArray2[i2], hashMap);
                }
                return stringArray;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return DefaultThrowableRenderer.render(throwable);
    }

    private String formatElement(Object object, Map map) {
        StringBuffer stringBuffer;
        block13: {
            stringBuffer = new StringBuffer("\tat ");
            stringBuffer.append(object);
            try {
                Object object2;
                Object object3;
                String string = this.getClassNameMethod.invoke(object, (Object[])null).toString();
                Object v2 = map.get(string);
                if (v2 != null) {
                    stringBuffer.append(v2);
                    break block13;
                }
                Class clazz = this.findClass(string);
                int n2 = stringBuffer.length();
                stringBuffer.append('[');
                try {
                    object3 = clazz.getProtectionDomain().getCodeSource();
                    if (object3 != null && (object2 = ((CodeSource)object3).getLocation()) != null) {
                        if ("file".equals(((URL)object2).getProtocol())) {
                            String string2 = ((URL)object2).getPath();
                            if (string2 != null) {
                                int n3 = string2.lastIndexOf(47);
                                int n4 = string2.lastIndexOf(File.separatorChar);
                                if (n4 > n3) {
                                    n3 = n4;
                                }
                                if (n3 <= 0 || n3 == string2.length() - 1) {
                                    stringBuffer.append(object2);
                                } else {
                                    stringBuffer.append(string2.substring(n3 + 1));
                                }
                            }
                        } else {
                            stringBuffer.append(object2);
                        }
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                stringBuffer.append(':');
                object3 = clazz.getPackage();
                if (object3 != null && (object2 = ((Package)object3).getImplementationVersion()) != null) {
                    stringBuffer.append((String)object2);
                }
                stringBuffer.append(']');
                map.put(string, stringBuffer.substring(n2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    private Class findClass(String string) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return this.getClass().getClassLoader().loadClass(string);
            }
        }
    }
}

