/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j;

import com.contrastsecurity.thirdparty.org.apache.log4j.Hierarchy;
import com.contrastsecurity.thirdparty.org.apache.log4j.Level;
import com.contrastsecurity.thirdparty.org.apache.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.Loader;
import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.LogLog;
import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.OptionConverter;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.DefaultRepositorySelector;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggerFactory;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggerRepository;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.NOPLoggerRepository;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.RepositorySelector;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.RootLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;

public class LogManager {
    public static final String DEFAULT_CONFIGURATION_FILE = "log4j.properties";
    static final String DEFAULT_XML_CONFIGURATION_FILE = "log4j.xml";
    public static final String DEFAULT_CONFIGURATION_KEY = "log4j.configuration";
    public static final String CONFIGURATOR_CLASS_KEY = "log4j.configuratorClass";
    public static final String DEFAULT_INIT_OVERRIDE_KEY = "log4j.defaultInitOverride";
    private static Object guard = null;
    private static RepositorySelector repositorySelector;

    public static void setRepositorySelector(RepositorySelector repositorySelector, Object object) throws IllegalArgumentException {
        if (guard != null && guard != object) {
            throw new IllegalArgumentException("Attempted to reset the LoggerFactory without possessing the guard.");
        }
        if (repositorySelector == null) {
            throw new IllegalArgumentException("RepositorySelector must be non-null.");
        }
        guard = object;
        LogManager.repositorySelector = repositorySelector;
    }

    private static boolean isLikelySafeScenario(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        String string = stringWriter.toString();
        return string.indexOf("com.contrastsecurity.thirdparty.org.apache.catalina.loader.WebappClassLoader.stop") != -1;
    }

    public static LoggerRepository getLoggerRepository() {
        if (repositorySelector == null) {
            repositorySelector = new DefaultRepositorySelector(new NOPLoggerRepository());
            guard = null;
            IllegalStateException illegalStateException = new IllegalStateException("Class invariant violation");
            String string = "log4j called after unloading, see http://logging.apache.org/log4j/1.2/faq.html#unload.";
            if (LogManager.isLikelySafeScenario(illegalStateException)) {
                LogLog.debug(string, illegalStateException);
            } else {
                LogLog.error(string, illegalStateException);
            }
        }
        return repositorySelector.getLoggerRepository();
    }

    public static Logger getRootLogger() {
        return LogManager.getLoggerRepository().getRootLogger();
    }

    public static Logger getLogger(String string) {
        return LogManager.getLoggerRepository().getLogger(string);
    }

    public static Logger getLogger(Class clazz) {
        return LogManager.getLoggerRepository().getLogger(clazz.getName());
    }

    public static Logger getLogger(String string, LoggerFactory loggerFactory) {
        return LogManager.getLoggerRepository().getLogger(string, loggerFactory);
    }

    public static Logger exists(String string) {
        return LogManager.getLoggerRepository().exists(string);
    }

    public static Enumeration getCurrentLoggers() {
        return LogManager.getLoggerRepository().getCurrentLoggers();
    }

    public static void shutdown() {
        LogManager.getLoggerRepository().shutdown();
    }

    public static void resetConfiguration() {
        LogManager.getLoggerRepository().resetConfiguration();
    }

    static {
        Hierarchy hierarchy = new Hierarchy(new RootLogger(Level.DEBUG));
        repositorySelector = new DefaultRepositorySelector(hierarchy);
        String string = OptionConverter.getSystemProperty(DEFAULT_INIT_OVERRIDE_KEY, null);
        if (string == null || "false".equalsIgnoreCase(string)) {
            String string2 = OptionConverter.getSystemProperty(DEFAULT_CONFIGURATION_KEY, null);
            String string3 = OptionConverter.getSystemProperty(CONFIGURATOR_CLASS_KEY, null);
            URL uRL = null;
            if (string2 == null) {
                uRL = Loader.getResource(DEFAULT_XML_CONFIGURATION_FILE);
                if (uRL == null) {
                    uRL = Loader.getResource(DEFAULT_CONFIGURATION_FILE);
                }
            } else {
                try {
                    uRL = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = Loader.getResource(string2);
                }
            }
            if (uRL != null) {
                LogLog.debug("Using URL [" + uRL + "] for automatic log4j configuration.");
                try {
                    OptionConverter.selectAndConfigure(uRL, string3, LogManager.getLoggerRepository());
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    LogLog.warn("Error during default initialization", noClassDefFoundError);
                }
            } else {
                LogLog.debug("Could not find resource: [" + string2 + "].");
            }
        } else {
            LogLog.debug("Default initialization of overridden by log4j.defaultInitOverrideproperty.");
        }
    }
}

