/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j;

import com.contrastsecurity.thirdparty.org.apache.log4j.Appender;
import com.contrastsecurity.thirdparty.org.apache.log4j.DefaultCategoryFactory;
import com.contrastsecurity.thirdparty.org.apache.log4j.Layout;
import com.contrastsecurity.thirdparty.org.apache.log4j.Level;
import com.contrastsecurity.thirdparty.org.apache.log4j.LogManager;
import com.contrastsecurity.thirdparty.org.apache.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.log4j.NameValue;
import com.contrastsecurity.thirdparty.org.apache.log4j.PropertyWatchdog;
import com.contrastsecurity.thirdparty.org.apache.log4j.SortedKeyEnumeration;
import com.contrastsecurity.thirdparty.org.apache.log4j.config.PropertySetter;
import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.LogLog;
import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.OptionConverter;
import com.contrastsecurity.thirdparty.org.apache.log4j.or.RendererMap;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.Configurator;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.ErrorHandler;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.Filter;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggerFactory;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggerRepository;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.OptionHandler;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.RendererSupport;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.ThrowableRenderer;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.ThrowableRendererSupport;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class PropertyConfigurator
implements Configurator {
    protected Hashtable registry = new Hashtable(11);
    private LoggerRepository repository;
    protected LoggerFactory loggerFactory = new DefaultCategoryFactory();
    static final String CATEGORY_PREFIX = "log4j.category.";
    static final String LOGGER_PREFIX = "log4j.logger.";
    static final String FACTORY_PREFIX = "log4j.factory";
    static final String ADDITIVITY_PREFIX = "log4j.additivity.";
    static final String ROOT_CATEGORY_PREFIX = "log4j.rootCategory";
    static final String ROOT_LOGGER_PREFIX = "log4j.rootLogger";
    static final String APPENDER_PREFIX = "log4j.appender.";
    static final String RENDERER_PREFIX = "log4j.renderer.";
    static final String THRESHOLD_PREFIX = "log4j.threshold";
    private static final String THROWABLE_RENDERER_PREFIX = "log4j.throwableRenderer";
    private static final String LOGGER_REF = "logger-ref";
    private static final String ROOT_REF = "root-ref";
    private static final String APPENDER_REF_TAG = "appender-ref";
    public static final String LOGGER_FACTORY_KEY = "log4j.loggerFactory";
    private static final String RESET_KEY = "log4j.reset";
    private static final String INTERNAL_ROOT_NAME = "root";
    static /* synthetic */ Class class$org$apache$log4j$spi$ThrowableRenderer;
    static /* synthetic */ Class class$org$apache$log4j$spi$Filter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConfigure(String string, LoggerRepository loggerRepository) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedIOException || exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error("Could not read configuration file [" + string + "].", exception);
            LogLog.error("Ignoring configuration file [" + string + "].");
            return;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (InterruptedIOException interruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {}
            }
        }
        this.doConfigure(properties, loggerRepository);
    }

    public static void configure(String string) {
        new PropertyConfigurator().doConfigure(string, LogManager.getLoggerRepository());
    }

    public static void configure(URL uRL) {
        new PropertyConfigurator().doConfigure(uRL, LogManager.getLoggerRepository());
    }

    public static void configure(InputStream inputStream) {
        new PropertyConfigurator().doConfigure(inputStream, LogManager.getLoggerRepository());
    }

    public static void configure(Properties properties) {
        new PropertyConfigurator().doConfigure(properties, LogManager.getLoggerRepository());
    }

    public static void configureAndWatch(String string) {
        PropertyConfigurator.configureAndWatch(string, 60000L);
    }

    public static void configureAndWatch(String string, long l2) {
        PropertyWatchdog propertyWatchdog = new PropertyWatchdog(string);
        propertyWatchdog.setDelay(l2);
        propertyWatchdog.start();
    }

    public void doConfigure(Properties properties, LoggerRepository loggerRepository) {
        String string;
        String string2;
        this.repository = loggerRepository;
        String string3 = properties.getProperty("log4j.debug");
        if (string3 == null && (string3 = properties.getProperty("log4j.configDebug")) != null) {
            LogLog.warn("[log4j.configDebug] is deprecated. Use [log4j.debug] instead.");
        }
        if (string3 != null) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(string3, true));
        }
        if ((string2 = properties.getProperty(RESET_KEY)) != null && OptionConverter.toBoolean(string2, false)) {
            loggerRepository.resetConfiguration();
        }
        if ((string = OptionConverter.findAndSubst(THRESHOLD_PREFIX, properties)) != null) {
            loggerRepository.setThreshold(OptionConverter.toLevel(string, Level.ALL));
            LogLog.debug("Hierarchy threshold set to [" + loggerRepository.getThreshold() + "].");
        }
        this.configureRootCategory(properties, loggerRepository);
        this.configureLoggerFactory(properties);
        this.parseCatsAndRenderers(properties, loggerRepository);
        LogLog.debug("Finished configuring.");
        this.registry.clear();
    }

    public void doConfigure(InputStream inputStream, LoggerRepository loggerRepository) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            if (iOException instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error("Could not read configuration file from InputStream [" + inputStream + "].", iOException);
            LogLog.error("Ignoring configuration InputStream [" + inputStream + "].");
            return;
        }
        this.doConfigure(properties, loggerRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConfigure(URL uRL, LoggerRepository loggerRepository) {
        Properties properties = new Properties();
        LogLog.debug("Reading configuration from URL " + uRL);
        InputStream inputStream = null;
        URLConnection uRLConnection = null;
        try {
            uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            inputStream = uRLConnection.getInputStream();
            properties.load(inputStream);
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedIOException || exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error("Could not read configuration file from URL [" + uRL + "].", exception);
            LogLog.error("Ignoring configuration file [" + uRL + "].");
            return;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (InterruptedIOException interruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException iOException) {
                }
                catch (RuntimeException runtimeException) {}
            }
        }
        this.doConfigure(properties, loggerRepository);
    }

    protected void configureLoggerFactory(Properties properties) {
        String string = OptionConverter.findAndSubst(LOGGER_FACTORY_KEY, properties);
        if (string != null) {
            LogLog.debug("Setting category factory to [" + string + "].");
            this.loggerFactory = (LoggerFactory)OptionConverter.instantiateByClassName(string, LoggerFactory.class, this.loggerFactory);
            PropertySetter.setProperties(this.loggerFactory, properties, "log4j.factory.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void configureRootCategory(Properties properties, LoggerRepository loggerRepository) {
        String string = ROOT_LOGGER_PREFIX;
        String string2 = OptionConverter.findAndSubst(ROOT_LOGGER_PREFIX, properties);
        if (string2 == null) {
            string2 = OptionConverter.findAndSubst(ROOT_CATEGORY_PREFIX, properties);
            string = ROOT_CATEGORY_PREFIX;
        }
        if (string2 == null) {
            LogLog.debug("Could not find root logger information. Is this OK?");
        } else {
            Logger logger;
            Logger logger2 = logger = loggerRepository.getRootLogger();
            synchronized (logger2) {
                this.parseCategory(properties, logger, string, INTERNAL_ROOT_NAME, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCatsAndRenderers(Properties properties, LoggerRepository loggerRepository) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            String string = (String)enumeration.nextElement();
            if (string.startsWith(CATEGORY_PREFIX) || string.startsWith(LOGGER_PREFIX)) {
                Logger logger;
                object2 = null;
                if (string.startsWith(CATEGORY_PREFIX)) {
                    object2 = string.substring(CATEGORY_PREFIX.length());
                } else if (string.startsWith(LOGGER_PREFIX)) {
                    object2 = string.substring(LOGGER_PREFIX.length());
                }
                object = OptionConverter.findAndSubst(string, properties);
                Logger logger2 = logger = loggerRepository.getLogger((String)object2, this.loggerFactory);
                synchronized (logger2) {
                    this.parseCategory(properties, logger, string, (String)object2, (String)object);
                    this.parseAdditivityForLogger(properties, logger, (String)object2);
                    continue;
                }
            }
            if (string.startsWith(RENDERER_PREFIX)) {
                object2 = string.substring(RENDERER_PREFIX.length());
                object = OptionConverter.findAndSubst(string, properties);
                if (!(loggerRepository instanceof RendererSupport)) continue;
                RendererMap.addRenderer((RendererSupport)((Object)loggerRepository), (String)object2, (String)object);
                continue;
            }
            if (!string.equals(THROWABLE_RENDERER_PREFIX) || !(loggerRepository instanceof ThrowableRendererSupport)) continue;
            object2 = (ThrowableRenderer)OptionConverter.instantiateByKey(properties, THROWABLE_RENDERER_PREFIX, class$org$apache$log4j$spi$ThrowableRenderer == null ? PropertyConfigurator.class$("com.contrastsecurity.thirdparty.org.apache.log4j.spi.ThrowableRenderer") : class$org$apache$log4j$spi$ThrowableRenderer, null);
            if (object2 == null) {
                LogLog.error("Could not instantiate throwableRenderer.");
                continue;
            }
            object = new PropertySetter(object2);
            ((PropertySetter)object).setProperties(properties, "log4j.throwableRenderer.");
            ((ThrowableRendererSupport)((Object)loggerRepository)).setThrowableRenderer((ThrowableRenderer)object2);
        }
    }

    void parseAdditivityForLogger(Properties properties, Logger logger, String string) {
        String string2 = OptionConverter.findAndSubst(ADDITIVITY_PREFIX + string, properties);
        LogLog.debug("Handling log4j.additivity." + string + "=[" + string2 + "]");
        if (string2 != null && !string2.equals("")) {
            boolean bl = OptionConverter.toBoolean(string2, true);
            LogLog.debug("Setting additivity for \"" + string + "\" to " + bl);
            logger.setAdditivity(bl);
        }
    }

    void parseCategory(Properties properties, Logger logger, String string, String string2, String string3) {
        Object object;
        LogLog.debug("Parsing for [" + string2 + "] with value=[" + string3 + "].");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        if (!string3.startsWith(",") && !string3.equals("")) {
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            object = stringTokenizer.nextToken();
            LogLog.debug("Level token is [" + (String)object + "].");
            if ("inherited".equalsIgnoreCase((String)object) || "null".equalsIgnoreCase((String)object)) {
                if (string2.equals(INTERNAL_ROOT_NAME)) {
                    LogLog.warn("The root logger cannot be set to null.");
                } else {
                    logger.setLevel(null);
                }
            } else {
                logger.setLevel(OptionConverter.toLevel((String)object, Level.DEBUG));
            }
            LogLog.debug("Category " + string2 + " set to " + logger.getLevel());
        }
        logger.removeAllAppenders();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            if (string4 == null || string4.equals(",")) continue;
            LogLog.debug("Parsing appender named \"" + string4 + "\".");
            object = this.parseAppender(properties, string4);
            if (object == null) continue;
            logger.addAppender((Appender)object);
        }
    }

    Appender parseAppender(Properties properties, String string) {
        Appender appender = this.registryGet(string);
        if (appender != null) {
            LogLog.debug("Appender \"" + string + "\" was already parsed.");
            return appender;
        }
        String string2 = APPENDER_PREFIX + string;
        String string3 = string2 + ".layout";
        appender = (Appender)OptionConverter.instantiateByKey(properties, string2, Appender.class, null);
        if (appender == null) {
            LogLog.error("Could not instantiate appender named \"" + string + "\".");
            return null;
        }
        appender.setName(string);
        if (appender instanceof OptionHandler) {
            ErrorHandler errorHandler;
            String string4;
            Object object;
            if (appender.requiresLayout() && (object = (Layout)OptionConverter.instantiateByKey(properties, string3, Layout.class, null)) != null) {
                appender.setLayout((Layout)object);
                LogLog.debug("Parsing layout options for \"" + string + "\".");
                PropertySetter.setProperties(object, properties, string3 + ".");
                LogLog.debug("End of parsing for \"" + string + "\".");
            }
            if ((string4 = OptionConverter.findAndSubst((String)(object = string2 + ".errorhandler"), properties)) != null && (errorHandler = (ErrorHandler)OptionConverter.instantiateByKey(properties, (String)object, ErrorHandler.class, null)) != null) {
                appender.setErrorHandler(errorHandler);
                LogLog.debug("Parsing errorhandler options for \"" + string + "\".");
                this.parseErrorHandler(errorHandler, (String)object, properties, this.repository);
                Properties properties2 = new Properties();
                String[] stringArray = new String[]{(String)object + "." + ROOT_REF, (String)object + "." + LOGGER_REF, (String)object + "." + APPENDER_REF_TAG};
                Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
                while (iterator.hasNext()) {
                    int n2;
                    Map.Entry<Object, Object> entry = iterator.next();
                    for (n2 = 0; n2 < stringArray.length && !stringArray[n2].equals(entry.getKey()); ++n2) {
                    }
                    if (n2 != stringArray.length) continue;
                    properties2.put(entry.getKey(), entry.getValue());
                }
                PropertySetter.setProperties(errorHandler, properties2, (String)object + ".");
                LogLog.debug("End of errorhandler parsing for \"" + string + "\".");
            }
            PropertySetter.setProperties(appender, properties, string2 + ".");
            LogLog.debug("Parsed \"" + string + "\" options.");
        }
        this.parseAppenderFilters(properties, string, appender);
        this.registryPut(appender);
        return appender;
    }

    private void parseErrorHandler(ErrorHandler errorHandler, String string, Properties properties, LoggerRepository loggerRepository) {
        Appender appender;
        Object object;
        String string2;
        boolean bl = OptionConverter.toBoolean(OptionConverter.findAndSubst(string + ROOT_REF, properties), false);
        if (bl) {
            errorHandler.setLogger(loggerRepository.getRootLogger());
        }
        if ((string2 = OptionConverter.findAndSubst(string + LOGGER_REF, properties)) != null) {
            object = this.loggerFactory == null ? loggerRepository.getLogger(string2) : loggerRepository.getLogger(string2, this.loggerFactory);
            errorHandler.setLogger((Logger)object);
        }
        if ((object = OptionConverter.findAndSubst(string + APPENDER_REF_TAG, properties)) != null && (appender = this.parseAppender(properties, (String)object)) != null) {
            errorHandler.setBackupAppender(appender);
        }
    }

    void parseAppenderFilters(Properties properties, String string, Appender appender) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string2 = APPENDER_PREFIX + string + ".filter.";
        int n2 = string2.length();
        Hashtable hashtable = new Hashtable();
        Enumeration<Object> enumeration = properties.keys();
        String string3 = "";
        while (enumeration.hasMoreElements()) {
            object4 = (String)enumeration.nextElement();
            if (!((String)object4).startsWith(string2)) continue;
            int n3 = ((String)object4).indexOf(46, n2);
            object3 = object4;
            if (n3 != -1) {
                object3 = ((String)object4).substring(0, n3);
                string3 = ((String)object4).substring(n3 + 1);
            }
            if ((object2 = (Vector<NameValue>)hashtable.get(object3)) == null) {
                object2 = new Vector<NameValue>();
                hashtable.put(object3, object2);
            }
            if (n3 == -1) continue;
            object = OptionConverter.findAndSubst((String)object4, properties);
            ((Vector)object2).add(new NameValue(string3, (String)object));
        }
        object4 = new SortedKeyEnumeration(hashtable);
        while (object4.hasMoreElements()) {
            String string4 = (String)object4.nextElement();
            object3 = properties.getProperty(string4);
            if (object3 != null) {
                LogLog.debug("Filter key: [" + string4 + "] class: [" + properties.getProperty(string4) + "] props: " + hashtable.get(string4));
                object2 = (Filter)OptionConverter.instantiateByClassName((String)object3, class$org$apache$log4j$spi$Filter == null ? PropertyConfigurator.class$("com.contrastsecurity.thirdparty.org.apache.log4j.spi.Filter") : class$org$apache$log4j$spi$Filter, null);
                if (object2 == null) continue;
                object = new PropertySetter(object2);
                Vector vector = (Vector)hashtable.get(string4);
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    NameValue nameValue = (NameValue)enumeration2.nextElement();
                    ((PropertySetter)object).setProperty(nameValue.key, nameValue.value);
                }
                ((PropertySetter)object).activate();
                LogLog.debug("Adding filter of type [" + object2.getClass() + "] to appender named [" + appender.getName() + "].");
                appender.addFilter((Filter)object2);
                continue;
            }
            LogLog.warn("Missing class definition for filter: [" + string4 + "]");
        }
    }

    void registryPut(Appender appender) {
        this.registry.put(appender.getName(), appender);
    }

    Appender registryGet(String string) {
        return (Appender)this.registry.get(string);
    }
}

