/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j;

import com.contrastsecurity.thirdparty.org.apache.log4j.FileAppender;
import com.contrastsecurity.thirdparty.org.apache.log4j.Layout;
import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.CountingQuietWriter;
import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.LogLog;
import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.OptionConverter;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggingEvent;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;

public class RollingFileAppender
extends FileAppender {
    protected long maxFileSize = 0xA00000L;
    protected int maxBackupIndex = 1;
    private long nextRollover = 0L;

    public RollingFileAppender() {
    }

    public RollingFileAppender(Layout layout, String string, boolean bl) throws IOException {
        super(layout, string, bl);
    }

    public RollingFileAppender(Layout layout, String string) throws IOException {
        super(layout, string);
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public long getMaximumFileSize() {
        return this.maxFileSize;
    }

    public void rollOver() {
        if (this.qw != null) {
            long l2 = ((CountingQuietWriter)this.qw).getCount();
            LogLog.debug("rolling over count=" + l2);
            this.nextRollover = l2 + this.maxFileSize;
        }
        LogLog.debug("maxBackupIndex=" + this.maxBackupIndex);
        boolean bl = true;
        if (this.maxBackupIndex > 0) {
            File file;
            File file2 = new File(this.fileName + '.' + this.maxBackupIndex);
            if (file2.exists()) {
                bl = file2.delete();
            }
            for (int i2 = this.maxBackupIndex - 1; i2 >= 1 && bl; --i2) {
                file2 = new File(this.fileName + "." + i2);
                if (!file2.exists()) continue;
                file = new File(this.fileName + '.' + (i2 + 1));
                LogLog.debug("Renaming file " + file2 + " to " + file);
                bl = file2.renameTo(file);
            }
            if (bl) {
                file = new File(this.fileName + "." + 1);
                this.closeFile();
                file2 = new File(this.fileName);
                LogLog.debug("Renaming file " + file2 + " to " + file);
                bl = file2.renameTo(file);
                if (!bl) {
                    try {
                        this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
                    }
                    catch (IOException iOException) {
                        if (iOException instanceof InterruptedIOException) {
                            Thread.currentThread().interrupt();
                        }
                        LogLog.error("setFile(" + this.fileName + ", true) call failed.", iOException);
                    }
                }
            }
        }
        if (bl) {
            try {
                this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
                this.nextRollover = 0L;
            }
            catch (IOException iOException) {
                if (iOException instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error("setFile(" + this.fileName + ", false) call failed.", iOException);
            }
        }
    }

    public synchronized void setFile(String string, boolean bl, boolean bl2, int n2) throws IOException {
        super.setFile(string, bl, this.bufferedIO, this.bufferSize);
        if (bl) {
            File file = new File(string);
            ((CountingQuietWriter)this.qw).setCount(file.length());
        }
    }

    public void setMaxBackupIndex(int n2) {
        this.maxBackupIndex = n2;
    }

    public void setMaximumFileSize(long l2) {
        this.maxFileSize = l2;
    }

    public void setMaxFileSize(String string) {
        this.maxFileSize = OptionConverter.toFileSize(string, this.maxFileSize + 1L);
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    protected void subAppend(LoggingEvent loggingEvent) {
        long l2;
        super.subAppend(loggingEvent);
        if (this.fileName != null && this.qw != null && (l2 = ((CountingQuietWriter)this.qw).getCount()) >= this.maxFileSize && l2 >= this.nextRollover) {
            this.rollOver();
        }
    }
}

