/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.chainsaw;

import com.contrastsecurity.thirdparty.org.apache.log4j.Level;
import com.contrastsecurity.thirdparty.org.apache.log4j.chainsaw.EventDetails;
import com.contrastsecurity.thirdparty.org.apache.log4j.chainsaw.MyTableModel;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XMLFileHandler
extends DefaultHandler {
    private static final String TAG_EVENT = "log4j:event";
    private static final String TAG_MESSAGE = "log4j:message";
    private static final String TAG_NDC = "log4j:NDC";
    private static final String TAG_THROWABLE = "log4j:throwable";
    private static final String TAG_LOCATION_INFO = "log4j:locationInfo";
    private final MyTableModel mModel;
    private int mNumEvents;
    private long mTimeStamp;
    private Level mLevel;
    private String mCategoryName;
    private String mNDC;
    private String mThreadName;
    private String mMessage;
    private String[] mThrowableStrRep;
    private String mLocationDetails;
    private final StringBuffer mBuf = new StringBuffer();

    XMLFileHandler(MyTableModel myTableModel) {
        this.mModel = myTableModel;
    }

    public void startDocument() throws SAXException {
        this.mNumEvents = 0;
    }

    public void characters(char[] cArray, int n2, int n3) {
        this.mBuf.append(String.valueOf(cArray, n2, n3));
    }

    public void endElement(String string, String string2, String string3) {
        if (TAG_EVENT.equals(string3)) {
            this.addEvent();
            this.resetData();
        } else if (TAG_NDC.equals(string3)) {
            this.mNDC = this.mBuf.toString();
        } else if (TAG_MESSAGE.equals(string3)) {
            this.mMessage = this.mBuf.toString();
        } else if (TAG_THROWABLE.equals(string3)) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.mBuf.toString(), "\n\t");
            this.mThrowableStrRep = new String[stringTokenizer.countTokens()];
            if (this.mThrowableStrRep.length > 0) {
                this.mThrowableStrRep[0] = stringTokenizer.nextToken();
                for (int i2 = 1; i2 < this.mThrowableStrRep.length; ++i2) {
                    this.mThrowableStrRep[i2] = "\t" + stringTokenizer.nextToken();
                }
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.mBuf.setLength(0);
        if (TAG_EVENT.equals(string3)) {
            this.mThreadName = attributes.getValue("thread");
            this.mTimeStamp = Long.parseLong(attributes.getValue("timestamp"));
            this.mCategoryName = attributes.getValue("logger");
            this.mLevel = Level.toLevel(attributes.getValue("level"));
        } else if (TAG_LOCATION_INFO.equals(string3)) {
            this.mLocationDetails = attributes.getValue("class") + "." + attributes.getValue("method") + "(" + attributes.getValue("file") + ":" + attributes.getValue("line") + ")";
        }
    }

    int getNumEvents() {
        return this.mNumEvents;
    }

    private void addEvent() {
        this.mModel.addEvent(new EventDetails(this.mTimeStamp, this.mLevel, this.mCategoryName, this.mNDC, this.mThreadName, this.mMessage, this.mThrowableStrRep, this.mLocationDetails));
        ++this.mNumEvents;
    }

    private void resetData() {
        this.mTimeStamp = 0L;
        this.mLevel = null;
        this.mCategoryName = null;
        this.mNDC = null;
        this.mThreadName = null;
        this.mMessage = null;
        this.mThrowableStrRep = null;
        this.mLocationDetails = null;
    }
}

