/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.helpers;

import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggingEvent;

public class BoundedFIFO {
    LoggingEvent[] buf;
    int numElements = 0;
    int first = 0;
    int next = 0;
    int maxSize;

    public BoundedFIFO(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("The maxSize argument (" + n2 + ") is not a positive integer.");
        }
        this.maxSize = n2;
        this.buf = new LoggingEvent[n2];
    }

    public LoggingEvent get() {
        if (this.numElements == 0) {
            return null;
        }
        LoggingEvent loggingEvent = this.buf[this.first];
        this.buf[this.first] = null;
        if (++this.first == this.maxSize) {
            this.first = 0;
        }
        --this.numElements;
        return loggingEvent;
    }

    public void put(LoggingEvent loggingEvent) {
        if (this.numElements != this.maxSize) {
            this.buf[this.next] = loggingEvent;
            if (++this.next == this.maxSize) {
                this.next = 0;
            }
            ++this.numElements;
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isFull() {
        return this.numElements == this.maxSize;
    }

    public int length() {
        return this.numElements;
    }

    int min(int n2, int n3) {
        return n2 < n3 ? n2 : n3;
    }

    public synchronized void resize(int n2) {
        if (n2 == this.maxSize) {
            return;
        }
        LoggingEvent[] loggingEventArray = new LoggingEvent[n2];
        int n3 = this.maxSize - this.first;
        n3 = this.min(n3, n2);
        n3 = this.min(n3, this.numElements);
        System.arraycopy(this.buf, this.first, loggingEventArray, 0, n3);
        int n4 = 0;
        if (n3 < this.numElements && n3 < n2) {
            n4 = this.numElements - n3;
            n4 = this.min(n4, n2 - n3);
            System.arraycopy(this.buf, 0, loggingEventArray, n3, n4);
        }
        this.buf = loggingEventArray;
        this.maxSize = n2;
        this.first = 0;
        this.next = this.numElements = n3 + n4;
        if (this.next == this.maxSize) {
            this.next = 0;
        }
    }

    public boolean wasEmpty() {
        return this.numElements == 1;
    }

    public boolean wasFull() {
        return this.numElements + 1 == this.maxSize;
    }
}

