/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.helpers;

import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggingEvent;

public class CyclicBuffer {
    LoggingEvent[] ea;
    int first;
    int last;
    int numElems;
    int maxSize;

    public CyclicBuffer(int n2) throws IllegalArgumentException {
        if (n2 < 1) {
            throw new IllegalArgumentException("The maxSize argument (" + n2 + ") is not a positive integer.");
        }
        this.maxSize = n2;
        this.ea = new LoggingEvent[n2];
        this.first = 0;
        this.last = 0;
        this.numElems = 0;
    }

    public void add(LoggingEvent loggingEvent) {
        this.ea[this.last] = loggingEvent;
        if (++this.last == this.maxSize) {
            this.last = 0;
        }
        if (this.numElems < this.maxSize) {
            ++this.numElems;
        } else if (++this.first == this.maxSize) {
            this.first = 0;
        }
    }

    public LoggingEvent get(int n2) {
        if (n2 < 0 || n2 >= this.numElems) {
            return null;
        }
        return this.ea[(this.first + n2) % this.maxSize];
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public LoggingEvent get() {
        LoggingEvent loggingEvent = null;
        if (this.numElems > 0) {
            --this.numElems;
            loggingEvent = this.ea[this.first];
            this.ea[this.first] = null;
            if (++this.first == this.maxSize) {
                this.first = 0;
            }
        }
        return loggingEvent;
    }

    public int length() {
        return this.numElems;
    }

    public void resize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative array size [" + n2 + "] not allowed.");
        }
        if (n2 == this.numElems) {
            return;
        }
        LoggingEvent[] loggingEventArray = new LoggingEvent[n2];
        int n3 = n2 < this.numElems ? n2 : this.numElems;
        for (int i2 = 0; i2 < n3; ++i2) {
            loggingEventArray[i2] = this.ea[this.first];
            this.ea[this.first] = null;
            if (++this.first != this.numElems) continue;
            this.first = 0;
        }
        this.ea = loggingEventArray;
        this.first = 0;
        this.numElems = n3;
        this.maxSize = n2;
        this.last = n3 == n2 ? 0 : n3;
    }
}

