/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.helpers;

import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.LogLog;
import java.io.File;

public abstract class FileWatchdog
extends Thread {
    public static final long DEFAULT_DELAY = 60000L;
    protected String filename;
    protected long delay = 60000L;
    File file;
    long lastModif = 0L;
    boolean warnedAlready = false;
    boolean interrupted = false;

    protected FileWatchdog(String string) {
        super("FileWatchdog");
        this.filename = string;
        this.file = new File(string);
        this.setDaemon(true);
        this.checkAndConfigure();
    }

    public void setDelay(long l2) {
        this.delay = l2;
    }

    protected abstract void doOnChange();

    protected void checkAndConfigure() {
        boolean bl;
        try {
            bl = this.file.exists();
        }
        catch (SecurityException securityException) {
            LogLog.warn("Was not allowed to read check file existance, file:[" + this.filename + "].");
            this.interrupted = true;
            return;
        }
        if (bl) {
            long l2 = this.file.lastModified();
            if (l2 > this.lastModif) {
                this.lastModif = l2;
                this.doOnChange();
                this.warnedAlready = false;
            }
        } else if (!this.warnedAlready) {
            LogLog.debug("[" + this.filename + "] does not exist.");
            this.warnedAlready = true;
        }
    }

    public void run() {
        while (!this.interrupted) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkAndConfigure();
        }
    }
}

