/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.helpers;

import com.contrastsecurity.thirdparty.org.apache.log4j.pattern.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggingEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.Set;

public final class MDCKeySetExtractor {
    private final Method getKeySetMethod;
    public static final MDCKeySetExtractor INSTANCE = new MDCKeySetExtractor();

    private MDCKeySetExtractor() {
        Method method = null;
        try {
            method = LoggingEvent.class.getMethod("getPropertyKeySet", null);
        }
        catch (Exception exception) {
            method = null;
        }
        this.getKeySetMethod = method;
    }

    public Set getPropertyKeySet(LoggingEvent loggingEvent) throws Exception {
        Set set = null;
        if (this.getKeySetMethod != null) {
            set = (Set)this.getKeySetMethod.invoke((Object)loggingEvent, null);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(loggingEvent);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            String string = LogEvent.class.getName();
            if (byArray[6] == 0 || byArray[7] == string.length()) {
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    byArray[8 + i2] = (byte)string.charAt(i2);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                Object object = objectInputStream.readObject();
                if (object instanceof LogEvent) {
                    set = ((LogEvent)object).getPropertyKeySet();
                }
                objectInputStream.close();
            }
        }
        return set;
    }
}

