/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.helpers;

import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.FormattingInfo;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggingEvent;

public abstract class PatternConverter {
    public PatternConverter next;
    int min = -1;
    int max = Integer.MAX_VALUE;
    boolean leftAlign = false;
    static String[] SPACES = new String[]{" ", "  ", "    ", "        ", "                ", "                                "};

    protected PatternConverter() {
    }

    protected PatternConverter(FormattingInfo formattingInfo) {
        this.min = formattingInfo.min;
        this.max = formattingInfo.max;
        this.leftAlign = formattingInfo.leftAlign;
    }

    protected abstract String convert(LoggingEvent var1);

    public void format(StringBuffer stringBuffer, LoggingEvent loggingEvent) {
        String string = this.convert(loggingEvent);
        if (string == null) {
            if (0 < this.min) {
                this.spacePad(stringBuffer, this.min);
            }
            return;
        }
        int n2 = string.length();
        if (n2 > this.max) {
            stringBuffer.append(string.substring(n2 - this.max));
        } else if (n2 < this.min) {
            if (this.leftAlign) {
                stringBuffer.append(string);
                this.spacePad(stringBuffer, this.min - n2);
            } else {
                this.spacePad(stringBuffer, this.min - n2);
                stringBuffer.append(string);
            }
        } else {
            stringBuffer.append(string);
        }
    }

    public void spacePad(StringBuffer stringBuffer, int n2) {
        while (n2 >= 32) {
            stringBuffer.append(SPACES[5]);
            n2 -= 32;
        }
        for (int i2 = 4; i2 >= 0; --i2) {
            if ((n2 & 1 << i2) == 0) continue;
            stringBuffer.append(SPACES[i2]);
        }
    }
}

