/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.helpers;

import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.LogLog;
import java.io.IOException;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;

public class SyslogWriter
extends Writer {
    final int SYSLOG_PORT = 514;
    static String syslogHost;
    private InetAddress address;
    private final int port;
    private DatagramSocket ds;

    public SyslogWriter(String string) {
        syslogHost = string;
        if (string == null) {
            throw new NullPointerException("syslogHost");
        }
        String string2 = string;
        int n2 = -1;
        if (string2.indexOf("[") != -1 || string2.indexOf(58) == string2.lastIndexOf(58)) {
            try {
                URL uRL = new URL("http://" + string2);
                if (uRL.getHost() != null) {
                    string2 = uRL.getHost();
                    if (string2.startsWith("[") && string2.charAt(string2.length() - 1) == ']') {
                        string2 = string2.substring(1, string2.length() - 1);
                    }
                    n2 = uRL.getPort();
                }
            }
            catch (MalformedURLException malformedURLException) {
                LogLog.error("Malformed URL: will attempt to interpret as InetAddress.", malformedURLException);
            }
        }
        if (n2 == -1) {
            n2 = 514;
        }
        this.port = n2;
        try {
            this.address = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            LogLog.error("Could not find " + string2 + ". All logging will FAIL.", unknownHostException);
        }
        try {
            this.ds = new DatagramSocket();
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            LogLog.error("Could not instantiate DatagramSocket to " + string2 + ". All logging will FAIL.", socketException);
        }
    }

    public void write(char[] cArray, int n2, int n3) throws IOException {
        this.write(new String(cArray, n2, n3));
    }

    public void write(String string) throws IOException {
        if (this.ds != null && this.address != null) {
            byte[] byArray = string.getBytes();
            int n2 = byArray.length;
            if (n2 >= 1024) {
                n2 = 1024;
            }
            DatagramPacket datagramPacket = new DatagramPacket(byArray, n2, this.address, this.port);
            this.ds.send(datagramPacket);
        }
    }

    public void flush() {
    }

    public void close() {
        if (this.ds != null) {
            this.ds.close();
        }
    }
}

