/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.lf5;

import com.contrastsecurity.thirdparty.org.apache.log4j.lf5.LogLevelFormatException;
import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LogLevel
implements Serializable {
    public static final LogLevel FATAL;
    public static final LogLevel ERROR;
    public static final LogLevel WARN;
    public static final LogLevel INFO;
    public static final LogLevel DEBUG;
    public static final LogLevel SEVERE;
    public static final LogLevel WARNING;
    public static final LogLevel CONFIG;
    public static final LogLevel FINE;
    public static final LogLevel FINER;
    public static final LogLevel FINEST;
    protected String _label;
    protected int _precedence;
    private static LogLevel[] _log4JLevels;
    private static LogLevel[] _jdk14Levels;
    private static LogLevel[] _allDefaultLevels;
    private static Map _logLevelMap;
    private static Map _logLevelColorMap;
    private static Map _registeredLogLevelMap;

    public LogLevel(String string, int n2) {
        this._label = string;
        this._precedence = n2;
    }

    public String getLabel() {
        return this._label;
    }

    public boolean encompasses(LogLevel logLevel) {
        return logLevel.getPrecedence() <= this.getPrecedence();
    }

    public static LogLevel valueOf(String string) throws LogLevelFormatException {
        LogLevel logLevel = null;
        if (string != null) {
            string = string.trim().toUpperCase();
            logLevel = (LogLevel)_logLevelMap.get(string);
        }
        if (logLevel == null && _registeredLogLevelMap.size() > 0) {
            logLevel = (LogLevel)_registeredLogLevelMap.get(string);
        }
        if (logLevel == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error while trying to parse (" + string + ") into");
            stringBuffer.append(" a LogLevel.");
            throw new LogLevelFormatException(stringBuffer.toString());
        }
        return logLevel;
    }

    public static LogLevel register(LogLevel logLevel) {
        if (logLevel == null) {
            return null;
        }
        if (_logLevelMap.get(logLevel.getLabel()) == null) {
            return _registeredLogLevelMap.put(logLevel.getLabel(), logLevel);
        }
        return null;
    }

    public static void register(LogLevel[] logLevelArray) {
        if (logLevelArray != null) {
            for (int i2 = 0; i2 < logLevelArray.length; ++i2) {
                LogLevel.register(logLevelArray[i2]);
            }
        }
    }

    public static void register(List list) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                LogLevel.register((LogLevel)iterator.next());
            }
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof LogLevel && this.getPrecedence() == ((LogLevel)object).getPrecedence()) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this._label.hashCode();
    }

    public String toString() {
        return this._label;
    }

    public void setLogLevelColorMap(LogLevel logLevel, Color color) {
        _logLevelColorMap.remove(logLevel);
        if (color == null) {
            color = Color.black;
        }
        _logLevelColorMap.put(logLevel, color);
    }

    public static void resetLogLevelColorMap() {
        _logLevelColorMap.clear();
        for (int i2 = 0; i2 < _allDefaultLevels.length; ++i2) {
            _logLevelColorMap.put(_allDefaultLevels[i2], Color.black);
        }
    }

    public static List getLog4JLevels() {
        return Arrays.asList(_log4JLevels);
    }

    public static List getJdk14Levels() {
        return Arrays.asList(_jdk14Levels);
    }

    public static List getAllDefaultLevels() {
        return Arrays.asList(_allDefaultLevels);
    }

    public static Map getLogLevelColorMap() {
        return _logLevelColorMap;
    }

    protected int getPrecedence() {
        return this._precedence;
    }

    static {
        int n2;
        FATAL = new LogLevel("FATAL", 0);
        ERROR = new LogLevel("ERROR", 1);
        WARN = new LogLevel("WARN", 2);
        INFO = new LogLevel("INFO", 3);
        DEBUG = new LogLevel("DEBUG", 4);
        SEVERE = new LogLevel("SEVERE", 1);
        WARNING = new LogLevel("WARNING", 2);
        CONFIG = new LogLevel("CONFIG", 4);
        FINE = new LogLevel("FINE", 5);
        FINER = new LogLevel("FINER", 6);
        FINEST = new LogLevel("FINEST", 7);
        _registeredLogLevelMap = new HashMap();
        _log4JLevels = new LogLevel[]{FATAL, ERROR, WARN, INFO, DEBUG};
        _jdk14Levels = new LogLevel[]{SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST};
        _allDefaultLevels = new LogLevel[]{FATAL, ERROR, WARN, INFO, DEBUG, SEVERE, WARNING, CONFIG, FINE, FINER, FINEST};
        _logLevelMap = new HashMap();
        for (n2 = 0; n2 < _allDefaultLevels.length; ++n2) {
            _logLevelMap.put(_allDefaultLevels[n2].getLabel(), _allDefaultLevels[n2]);
        }
        _logLevelColorMap = new HashMap();
        for (n2 = 0; n2 < _allDefaultLevels.length; ++n2) {
            _logLevelColorMap.put(_allDefaultLevels[n2], Color.black);
        }
    }
}

