/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.lf5.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateFormatManager {
    private TimeZone _timeZone = null;
    private Locale _locale = null;
    private String _pattern = null;
    private DateFormat _dateFormat = null;

    public DateFormatManager() {
        this.configure();
    }

    public DateFormatManager(TimeZone timeZone) {
        this._timeZone = timeZone;
        this.configure();
    }

    public DateFormatManager(Locale locale) {
        this._locale = locale;
        this.configure();
    }

    public DateFormatManager(String string) {
        this._pattern = string;
        this.configure();
    }

    public DateFormatManager(TimeZone timeZone, Locale locale) {
        this._timeZone = timeZone;
        this._locale = locale;
        this.configure();
    }

    public DateFormatManager(TimeZone timeZone, String string) {
        this._timeZone = timeZone;
        this._pattern = string;
        this.configure();
    }

    public DateFormatManager(Locale locale, String string) {
        this._locale = locale;
        this._pattern = string;
        this.configure();
    }

    public DateFormatManager(TimeZone timeZone, Locale locale, String string) {
        this._timeZone = timeZone;
        this._locale = locale;
        this._pattern = string;
        this.configure();
    }

    public synchronized TimeZone getTimeZone() {
        if (this._timeZone == null) {
            return TimeZone.getDefault();
        }
        return this._timeZone;
    }

    public synchronized void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
        this.configure();
    }

    public synchronized Locale getLocale() {
        if (this._locale == null) {
            return Locale.getDefault();
        }
        return this._locale;
    }

    public synchronized void setLocale(Locale locale) {
        this._locale = locale;
        this.configure();
    }

    public synchronized String getPattern() {
        return this._pattern;
    }

    public synchronized void setPattern(String string) {
        this._pattern = string;
        this.configure();
    }

    public synchronized String getOutputFormat() {
        return this._pattern;
    }

    public synchronized void setOutputFormat(String string) {
        this._pattern = string;
        this.configure();
    }

    public synchronized DateFormat getDateFormatInstance() {
        return this._dateFormat;
    }

    public synchronized void setDateFormatInstance(DateFormat dateFormat) {
        this._dateFormat = dateFormat;
    }

    public String format(Date date) {
        return this.getDateFormatInstance().format(date);
    }

    public String format(Date date, String string) {
        DateFormat dateFormat = null;
        dateFormat = this.getDateFormatInstance();
        if (dateFormat instanceof SimpleDateFormat) {
            dateFormat = (SimpleDateFormat)dateFormat.clone();
            ((SimpleDateFormat)dateFormat).applyPattern(string);
        }
        return dateFormat.format(date);
    }

    public Date parse(String string) throws ParseException {
        return this.getDateFormatInstance().parse(string);
    }

    public Date parse(String string, String string2) throws ParseException {
        DateFormat dateFormat = null;
        dateFormat = this.getDateFormatInstance();
        if (dateFormat instanceof SimpleDateFormat) {
            dateFormat = (SimpleDateFormat)dateFormat.clone();
            ((SimpleDateFormat)dateFormat).applyPattern(string2);
        }
        return dateFormat.parse(string);
    }

    private synchronized void configure() {
        this._dateFormat = SimpleDateFormat.getDateTimeInstance(0, 0, this.getLocale());
        this._dateFormat.setTimeZone(this.getTimeZone());
        if (this._pattern != null) {
            ((SimpleDateFormat)this._dateFormat).applyPattern(this._pattern);
        }
    }
}

