/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.lf5.util;

import com.contrastsecurity.thirdparty.org.apache.log4j.lf5.LogLevel;
import com.contrastsecurity.thirdparty.org.apache.log4j.lf5.LogRecord;
import com.contrastsecurity.thirdparty.org.apache.log4j.lf5.util.AdapterLogRecord;
import com.contrastsecurity.thirdparty.org.apache.log4j.lf5.viewer.LogBrokerMonitor;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.List;

public class LogMonitorAdapter {
    public static final int LOG4J_LOG_LEVELS = 0;
    public static final int JDK14_LOG_LEVELS = 1;
    private LogBrokerMonitor _logMonitor;
    private LogLevel _defaultLevel = null;

    private LogMonitorAdapter(List list) {
        this._defaultLevel = (LogLevel)list.get(0);
        this._logMonitor = new LogBrokerMonitor(list);
        this._logMonitor.setFrameSize(LogMonitorAdapter.getDefaultMonitorWidth(), LogMonitorAdapter.getDefaultMonitorHeight());
        this._logMonitor.setFontSize(12);
        this._logMonitor.show();
    }

    public static LogMonitorAdapter newInstance(int n2) {
        LogMonitorAdapter logMonitorAdapter;
        if (n2 == 1) {
            logMonitorAdapter = LogMonitorAdapter.newInstance(LogLevel.getJdk14Levels());
            logMonitorAdapter.setDefaultLevel(LogLevel.FINEST);
            logMonitorAdapter.setSevereLevel(LogLevel.SEVERE);
        } else {
            logMonitorAdapter = LogMonitorAdapter.newInstance(LogLevel.getLog4JLevels());
            logMonitorAdapter.setDefaultLevel(LogLevel.DEBUG);
            logMonitorAdapter.setSevereLevel(LogLevel.FATAL);
        }
        return logMonitorAdapter;
    }

    public static LogMonitorAdapter newInstance(LogLevel[] logLevelArray) {
        if (logLevelArray == null) {
            return null;
        }
        return LogMonitorAdapter.newInstance(Arrays.asList(logLevelArray));
    }

    public static LogMonitorAdapter newInstance(List list) {
        return new LogMonitorAdapter(list);
    }

    public void addMessage(LogRecord logRecord) {
        this._logMonitor.addMessage(logRecord);
    }

    public void setMaxNumberOfRecords(int n2) {
        this._logMonitor.setMaxNumberOfLogRecords(n2);
    }

    public void setDefaultLevel(LogLevel logLevel) {
        this._defaultLevel = logLevel;
    }

    public LogLevel getDefaultLevel() {
        return this._defaultLevel;
    }

    public void setSevereLevel(LogLevel logLevel) {
        AdapterLogRecord.setSevereLevel(logLevel);
    }

    public LogLevel getSevereLevel() {
        return AdapterLogRecord.getSevereLevel();
    }

    public void log(String string, LogLevel logLevel, String string2, Throwable throwable, String string3) {
        AdapterLogRecord adapterLogRecord = new AdapterLogRecord();
        adapterLogRecord.setCategory(string);
        adapterLogRecord.setMessage(string2);
        adapterLogRecord.setNDC(string3);
        adapterLogRecord.setThrown(throwable);
        if (logLevel == null) {
            adapterLogRecord.setLevel(this.getDefaultLevel());
        } else {
            adapterLogRecord.setLevel(logLevel);
        }
        this.addMessage(adapterLogRecord);
    }

    public void log(String string, String string2) {
        this.log(string, null, string2);
    }

    public void log(String string, LogLevel logLevel, String string2, String string3) {
        this.log(string, logLevel, string2, null, string3);
    }

    public void log(String string, LogLevel logLevel, String string2, Throwable throwable) {
        this.log(string, logLevel, string2, throwable, null);
    }

    public void log(String string, LogLevel logLevel, String string2) {
        this.log(string, logLevel, string2, null, null);
    }

    protected static int getScreenWidth() {
        try {
            return Toolkit.getDefaultToolkit().getScreenSize().width;
        }
        catch (Throwable throwable) {
            return 800;
        }
    }

    protected static int getScreenHeight() {
        try {
            return Toolkit.getDefaultToolkit().getScreenSize().height;
        }
        catch (Throwable throwable) {
            return 600;
        }
    }

    protected static int getDefaultMonitorWidth() {
        return 3 * LogMonitorAdapter.getScreenWidth() / 4;
    }

    protected static int getDefaultMonitorHeight() {
        return 3 * LogMonitorAdapter.getScreenHeight() / 4;
    }
}

