/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.lf5.viewer;

import com.contrastsecurity.thirdparty.org.apache.log4j.lf5.viewer.TrackingAdjustmentListener;
import java.awt.Adjustable;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class LF5SwingUtils {
    public static void selectRow(int n2, JTable jTable, JScrollPane jScrollPane) {
        if (jTable == null || jScrollPane == null) {
            return;
        }
        if (!LF5SwingUtils.contains(n2, jTable.getModel())) {
            return;
        }
        LF5SwingUtils.moveAdjustable(n2 * jTable.getRowHeight(), jScrollPane.getVerticalScrollBar());
        LF5SwingUtils.selectRow(n2, jTable.getSelectionModel());
        LF5SwingUtils.repaintLater(jTable);
    }

    public static void makeScrollBarTrack(Adjustable adjustable) {
        if (adjustable == null) {
            return;
        }
        adjustable.addAdjustmentListener(new TrackingAdjustmentListener());
    }

    public static void makeVerticalScrollBarTrack(JScrollPane jScrollPane) {
        if (jScrollPane == null) {
            return;
        }
        LF5SwingUtils.makeScrollBarTrack(jScrollPane.getVerticalScrollBar());
    }

    protected static boolean contains(int n2, TableModel tableModel) {
        if (tableModel == null) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        return n2 < tableModel.getRowCount();
    }

    protected static void selectRow(int n2, ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            return;
        }
        listSelectionModel.setSelectionInterval(n2, n2);
    }

    protected static void moveAdjustable(int n2, Adjustable adjustable) {
        if (adjustable == null) {
            return;
        }
        adjustable.setValue(n2);
    }

    protected static void repaintLater(final JComponent jComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jComponent.repaint();
            }
        });
    }
}

