/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.lf5.viewer;

import com.contrastsecurity.thirdparty.org.apache.log4j.lf5.util.DateFormatManager;
import com.contrastsecurity.thirdparty.org.apache.log4j.lf5.viewer.FilteredLogTableModel;
import com.contrastsecurity.thirdparty.org.apache.log4j.lf5.viewer.LogTableColumn;
import com.contrastsecurity.thirdparty.org.apache.log4j.lf5.viewer.LogTableRowRenderer;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class LogTable
extends JTable {
    private static final long serialVersionUID = 4867085140195148458L;
    protected int _rowHeight = 30;
    protected JTextArea _detailTextArea;
    protected int _numCols = 9;
    protected TableColumn[] _tableColumns = new TableColumn[this._numCols];
    protected int[] _colWidths = new int[]{40, 40, 40, 70, 70, 360, 440, 200, 60};
    protected LogTableColumn[] _colNames = LogTableColumn.getLogTableColumnArray();
    protected int _colDate = 0;
    protected int _colThread = 1;
    protected int _colMessageNum = 2;
    protected int _colLevel = 3;
    protected int _colNDC = 4;
    protected int _colCategory = 5;
    protected int _colMessage = 6;
    protected int _colLocation = 7;
    protected int _colThrown = 8;
    protected DateFormatManager _dateFormatManager = null;

    public LogTable(JTextArea jTextArea) {
        Object object;
        this.init();
        this._detailTextArea = jTextArea;
        this.setModel(new FilteredLogTableModel());
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            ((TableColumn)object).setCellRenderer(new LogTableRowRenderer());
            ((TableColumn)object).setPreferredWidth(this._colWidths[n2]);
            this._tableColumns[n2] = object;
            ++n2;
        }
        object = this.getSelectionModel();
        object.addListSelectionListener(new LogTableListSelectionListener(this));
    }

    public DateFormatManager getDateFormatManager() {
        return this._dateFormatManager;
    }

    public void setDateFormatManager(DateFormatManager dateFormatManager) {
        this._dateFormatManager = dateFormatManager;
    }

    public synchronized void clearLogRecords() {
        this.getFilteredLogTableModel().clear();
    }

    public FilteredLogTableModel getFilteredLogTableModel() {
        return (FilteredLogTableModel)this.getModel();
    }

    public void setDetailedView() {
        int n2;
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (n2 = 0; n2 < this._numCols; ++n2) {
            tableColumnModel.removeColumn(this._tableColumns[n2]);
        }
        for (n2 = 0; n2 < this._numCols; ++n2) {
            tableColumnModel.addColumn(this._tableColumns[n2]);
        }
        this.sizeColumnsToFit(-1);
    }

    public void setView(List list) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i2 = 0; i2 < this._numCols; ++i2) {
            tableColumnModel.removeColumn(this._tableColumns[i2]);
        }
        Iterator iterator = list.iterator();
        Vector vector = this.getColumnNameAndNumber();
        while (iterator.hasNext()) {
            tableColumnModel.addColumn(this._tableColumns[vector.indexOf(iterator.next())]);
        }
        this.sizeColumnsToFit(-1);
    }

    public void setFont(Font font) {
        super.setFont(font);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n2 = fontMetrics.getHeight();
            this._rowHeight = n2 + n2 / 3;
            this.setRowHeight(this._rowHeight);
        }
    }

    protected void init() {
        this.setRowHeight(this._rowHeight);
        this.setSelectionMode(0);
    }

    protected Vector getColumnNameAndNumber() {
        Vector<LogTableColumn> vector = new Vector<LogTableColumn>();
        for (int i2 = 0; i2 < this._colNames.length; ++i2) {
            vector.add(i2, this._colNames[i2]);
        }
        return vector;
    }

    class LogTableListSelectionListener
    implements ListSelectionListener {
        protected JTable _table;

        public LogTableListSelectionListener(JTable jTable) {
            this._table = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.isSelectionEmpty()) {
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = listSelectionModel.getMinSelectionIndex();
                for (int i2 = 0; i2 < LogTable.this._numCols - 1; ++i2) {
                    String string = "";
                    Object object = this._table.getModel().getValueAt(n2, i2);
                    if (object != null) {
                        string = object.toString();
                    }
                    stringBuffer.append(LogTable.this._colNames[i2] + ":");
                    stringBuffer.append("\t");
                    if (i2 == LogTable.this._colThread || i2 == LogTable.this._colMessage || i2 == LogTable.this._colLevel) {
                        stringBuffer.append("\t");
                    }
                    if (i2 == LogTable.this._colDate || i2 == LogTable.this._colNDC) {
                        stringBuffer.append("\t\t");
                    }
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                }
                stringBuffer.append(LogTable.this._colNames[LogTable.this._numCols - 1] + ":\n");
                Object object = this._table.getModel().getValueAt(n2, LogTable.this._numCols - 1);
                if (object != null) {
                    stringBuffer.append(object.toString());
                }
                LogTable.this._detailTextArea.setText(stringBuffer.toString());
            }
        }
    }
}

