/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.lf5.viewer.categoryexplorer;

import com.contrastsecurity.thirdparty.org.apache.log4j.lf5.LogRecord;
import com.contrastsecurity.thirdparty.org.apache.log4j.lf5.viewer.categoryexplorer.CategoryElement;
import com.contrastsecurity.thirdparty.org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import com.contrastsecurity.thirdparty.org.apache.log4j.lf5.viewer.categoryexplorer.CategoryPath;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CategoryExplorerModel
extends DefaultTreeModel {
    private static final long serialVersionUID = -3413887384316015901L;
    protected boolean _renderFatal = true;
    protected ActionListener _listener = null;
    protected ActionEvent _event = new ActionEvent(this, 1001, "Nodes Selection changed");

    public CategoryExplorerModel(CategoryNode categoryNode) {
        super(categoryNode);
    }

    public void addLogRecord(LogRecord logRecord) {
        CategoryPath categoryPath = new CategoryPath(logRecord.getCategory());
        this.addCategory(categoryPath);
        CategoryNode categoryNode = this.getCategoryNode(categoryPath);
        categoryNode.addRecord();
        if (this._renderFatal && logRecord.isFatal()) {
            TreeNode[] treeNodeArray = this.getPathToRoot(categoryNode);
            int n2 = treeNodeArray.length;
            for (int i2 = 1; i2 < n2 - 1; ++i2) {
                CategoryNode categoryNode2 = (CategoryNode)treeNodeArray[i2];
                categoryNode2.setHasFatalChildren(true);
                this.nodeChanged(categoryNode2);
            }
            categoryNode.setHasFatalRecords(true);
            this.nodeChanged(categoryNode);
        }
    }

    public CategoryNode getRootCategoryNode() {
        return (CategoryNode)this.getRoot();
    }

    public CategoryNode getCategoryNode(String string) {
        CategoryPath categoryPath = new CategoryPath(string);
        return this.getCategoryNode(categoryPath);
    }

    public CategoryNode getCategoryNode(CategoryPath categoryPath) {
        CategoryNode categoryNode;
        CategoryNode categoryNode2 = categoryNode = (CategoryNode)this.getRoot();
        for (int i2 = 0; i2 < categoryPath.size(); ++i2) {
            CategoryElement categoryElement = categoryPath.categoryElementAt(i2);
            Enumeration<TreeNode> enumeration = categoryNode2.children();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string;
                CategoryNode categoryNode3 = (CategoryNode)enumeration.nextElement();
                String string2 = categoryNode3.getTitle().toLowerCase();
                if (!string2.equals(string = categoryElement.getTitle().toLowerCase())) continue;
                bl = true;
                categoryNode2 = categoryNode3;
                break;
            }
            if (bl) continue;
            return null;
        }
        return categoryNode2;
    }

    public boolean isCategoryPathActive(CategoryPath categoryPath) {
        CategoryNode categoryNode;
        CategoryNode categoryNode2 = categoryNode = (CategoryNode)this.getRoot();
        boolean bl = false;
        for (int i2 = 0; i2 < categoryPath.size(); ++i2) {
            CategoryElement categoryElement = categoryPath.categoryElementAt(i2);
            Enumeration<TreeNode> enumeration = categoryNode2.children();
            boolean bl2 = false;
            bl = false;
            while (enumeration.hasMoreElements()) {
                String string;
                CategoryNode categoryNode3 = (CategoryNode)enumeration.nextElement();
                String string2 = categoryNode3.getTitle().toLowerCase();
                if (!string2.equals(string = categoryElement.getTitle().toLowerCase())) continue;
                bl2 = true;
                categoryNode2 = categoryNode3;
                if (!categoryNode2.isSelected()) break;
                bl = true;
                break;
            }
            if (bl && bl2) continue;
            return false;
        }
        return bl;
    }

    public CategoryNode addCategory(CategoryPath categoryPath) {
        CategoryNode categoryNode;
        CategoryNode categoryNode2 = categoryNode = (CategoryNode)this.getRoot();
        for (int i2 = 0; i2 < categoryPath.size(); ++i2) {
            CategoryNode categoryNode3;
            CategoryElement categoryElement = categoryPath.categoryElementAt(i2);
            Enumeration<TreeNode> enumeration = categoryNode2.children();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string;
                categoryNode3 = (CategoryNode)enumeration.nextElement();
                String string2 = categoryNode3.getTitle().toLowerCase();
                if (!string2.equals(string = categoryElement.getTitle().toLowerCase())) continue;
                bl = true;
                categoryNode2 = categoryNode3;
                break;
            }
            if (bl) continue;
            categoryNode3 = new CategoryNode(categoryElement.getTitle());
            this.insertNodeInto(categoryNode3, categoryNode2, categoryNode2.getChildCount());
            this.refresh(categoryNode3);
            categoryNode2 = categoryNode3;
        }
        return categoryNode2;
    }

    public void update(CategoryNode categoryNode, boolean bl) {
        if (categoryNode.isSelected() == bl) {
            return;
        }
        if (bl) {
            this.setParentSelection(categoryNode, true);
        } else {
            this.setDescendantSelection(categoryNode, false);
        }
    }

    public void setDescendantSelection(CategoryNode categoryNode, boolean bl) {
        Enumeration<TreeNode> enumeration = categoryNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CategoryNode categoryNode2 = (CategoryNode)enumeration.nextElement();
            if (categoryNode2.isSelected() == bl) continue;
            categoryNode2.setSelected(bl);
            this.nodeChanged(categoryNode2);
        }
        this.notifyActionListeners();
    }

    public void setParentSelection(CategoryNode categoryNode, boolean bl) {
        TreeNode[] treeNodeArray = this.getPathToRoot(categoryNode);
        int n2 = treeNodeArray.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            CategoryNode categoryNode2 = (CategoryNode)treeNodeArray[i2];
            if (categoryNode2.isSelected() == bl) continue;
            categoryNode2.setSelected(bl);
            this.nodeChanged(categoryNode2);
        }
        this.notifyActionListeners();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this._listener = AWTEventMulticaster.add(this._listener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this._listener = AWTEventMulticaster.remove(this._listener, actionListener);
    }

    public void resetAllNodeCounts() {
        Enumeration<TreeNode> enumeration = this.getRootCategoryNode().depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CategoryNode categoryNode = (CategoryNode)enumeration.nextElement();
            categoryNode.resetNumberOfContainedRecords();
            this.nodeChanged(categoryNode);
        }
    }

    public TreePath getTreePathToRoot(CategoryNode categoryNode) {
        if (categoryNode == null) {
            return null;
        }
        return new TreePath(this.getPathToRoot(categoryNode));
    }

    protected void notifyActionListeners() {
        if (this._listener != null) {
            this._listener.actionPerformed(this._event);
        }
    }

    protected void refresh(final CategoryNode categoryNode) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CategoryExplorerModel.this.nodeChanged(categoryNode);
            }
        });
    }
}

