/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.net;

import com.contrastsecurity.thirdparty.org.apache.log4j.AppenderSkeleton;
import com.contrastsecurity.thirdparty.org.apache.log4j.Layout;
import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.SyslogQuietWriter;
import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.SyslogWriter;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggingEvent;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SyslogAppender
extends AppenderSkeleton {
    public static final int LOG_KERN = 0;
    public static final int LOG_USER = 8;
    public static final int LOG_MAIL = 16;
    public static final int LOG_DAEMON = 24;
    public static final int LOG_AUTH = 32;
    public static final int LOG_SYSLOG = 40;
    public static final int LOG_LPR = 48;
    public static final int LOG_NEWS = 56;
    public static final int LOG_UUCP = 64;
    public static final int LOG_CRON = 72;
    public static final int LOG_AUTHPRIV = 80;
    public static final int LOG_FTP = 88;
    public static final int LOG_LOCAL0 = 128;
    public static final int LOG_LOCAL1 = 136;
    public static final int LOG_LOCAL2 = 144;
    public static final int LOG_LOCAL3 = 152;
    public static final int LOG_LOCAL4 = 160;
    public static final int LOG_LOCAL5 = 168;
    public static final int LOG_LOCAL6 = 176;
    public static final int LOG_LOCAL7 = 184;
    protected static final int SYSLOG_HOST_OI = 0;
    protected static final int FACILITY_OI = 1;
    static final String TAB = "    ";
    int syslogFacility = 8;
    String facilityStr;
    boolean facilityPrinting = false;
    SyslogQuietWriter sqw;
    String syslogHost;
    private boolean header = false;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss ", Locale.ENGLISH);
    private String localHostname;
    private boolean layoutHeaderChecked = false;

    public SyslogAppender() {
        this.initSyslogFacilityStr();
    }

    public SyslogAppender(Layout layout, int n2) {
        this.layout = layout;
        this.syslogFacility = n2;
        this.initSyslogFacilityStr();
    }

    public SyslogAppender(Layout layout, String string, int n2) {
        this(layout, n2);
        this.setSyslogHost(string);
    }

    public synchronized void close() {
        this.closed = true;
        if (this.sqw != null) {
            try {
                if (this.layoutHeaderChecked && this.layout != null && this.layout.getFooter() != null) {
                    this.sendLayoutMessage(this.layout.getFooter());
                }
                this.sqw.close();
                this.sqw = null;
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread.currentThread().interrupt();
                this.sqw = null;
            }
            catch (IOException iOException) {
                this.sqw = null;
            }
        }
    }

    private void initSyslogFacilityStr() {
        this.facilityStr = SyslogAppender.getFacilityString(this.syslogFacility);
        if (this.facilityStr == null) {
            System.err.println("\"" + this.syslogFacility + "\" is an unknown syslog facility. Defaulting to \"USER\".");
            this.syslogFacility = 8;
            this.facilityStr = "user:";
        } else {
            this.facilityStr = this.facilityStr + ":";
        }
    }

    public static String getFacilityString(int n2) {
        switch (n2) {
            case 0: {
                return "kern";
            }
            case 8: {
                return "user";
            }
            case 16: {
                return "mail";
            }
            case 24: {
                return "daemon";
            }
            case 32: {
                return "auth";
            }
            case 40: {
                return "syslog";
            }
            case 48: {
                return "lpr";
            }
            case 56: {
                return "news";
            }
            case 64: {
                return "uucp";
            }
            case 72: {
                return "cron";
            }
            case 80: {
                return "authpriv";
            }
            case 88: {
                return "ftp";
            }
            case 128: {
                return "local0";
            }
            case 136: {
                return "local1";
            }
            case 144: {
                return "local2";
            }
            case 152: {
                return "local3";
            }
            case 160: {
                return "local4";
            }
            case 168: {
                return "local5";
            }
            case 176: {
                return "local6";
            }
            case 184: {
                return "local7";
            }
        }
        return null;
    }

    public static int getFacility(String string) {
        if (string != null) {
            string = string.trim();
        }
        if ("KERN".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("USER".equalsIgnoreCase(string)) {
            return 8;
        }
        if ("MAIL".equalsIgnoreCase(string)) {
            return 16;
        }
        if ("DAEMON".equalsIgnoreCase(string)) {
            return 24;
        }
        if ("AUTH".equalsIgnoreCase(string)) {
            return 32;
        }
        if ("SYSLOG".equalsIgnoreCase(string)) {
            return 40;
        }
        if ("LPR".equalsIgnoreCase(string)) {
            return 48;
        }
        if ("NEWS".equalsIgnoreCase(string)) {
            return 56;
        }
        if ("UUCP".equalsIgnoreCase(string)) {
            return 64;
        }
        if ("CRON".equalsIgnoreCase(string)) {
            return 72;
        }
        if ("AUTHPRIV".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("FTP".equalsIgnoreCase(string)) {
            return 88;
        }
        if ("LOCAL0".equalsIgnoreCase(string)) {
            return 128;
        }
        if ("LOCAL1".equalsIgnoreCase(string)) {
            return 136;
        }
        if ("LOCAL2".equalsIgnoreCase(string)) {
            return 144;
        }
        if ("LOCAL3".equalsIgnoreCase(string)) {
            return 152;
        }
        if ("LOCAL4".equalsIgnoreCase(string)) {
            return 160;
        }
        if ("LOCAL5".equalsIgnoreCase(string)) {
            return 168;
        }
        if ("LOCAL6".equalsIgnoreCase(string)) {
            return 176;
        }
        if ("LOCAL7".equalsIgnoreCase(string)) {
            return 184;
        }
        return -1;
    }

    private void splitPacket(String string, String string2) {
        int n2 = string2.getBytes().length;
        if (n2 <= 1019) {
            this.sqw.write(string2);
        } else {
            int n3 = string.length() + (string2.length() - string.length()) / 2;
            this.splitPacket(string, string2.substring(0, n3) + "...");
            this.splitPacket(string, string + "..." + string2.substring(n3));
        }
    }

    public void append(LoggingEvent loggingEvent) {
        String[] stringArray;
        if (!this.isAsSevereAsThreshold(loggingEvent.getLevel())) {
            return;
        }
        if (this.sqw == null) {
            this.errorHandler.error("No syslog host is set for SyslogAppedender named \"" + this.name + "\".");
            return;
        }
        if (!this.layoutHeaderChecked) {
            if (this.layout != null && this.layout.getHeader() != null) {
                this.sendLayoutMessage(this.layout.getHeader());
            }
            this.layoutHeaderChecked = true;
        }
        String string = this.getPacketHeader(loggingEvent.timeStamp);
        String string2 = this.layout == null ? String.valueOf(loggingEvent.getMessage()) : this.layout.format(loggingEvent);
        if (this.facilityPrinting || string.length() > 0) {
            stringArray = new StringBuffer(string);
            if (this.facilityPrinting) {
                stringArray.append(this.facilityStr);
            }
            stringArray.append(string2);
            string2 = stringArray.toString();
        }
        this.sqw.setLevel(loggingEvent.getLevel().getSyslogEquivalent());
        if (string2.length() > 256) {
            this.splitPacket(string, string2);
        } else {
            this.sqw.write(string2);
        }
        if ((this.layout == null || this.layout.ignoresThrowable()) && (stringArray = loggingEvent.getThrowableStrRep()) != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].startsWith("\t")) {
                    this.sqw.write(string + TAB + stringArray[i2].substring(1));
                    continue;
                }
                this.sqw.write(string + stringArray[i2]);
            }
        }
    }

    public void activateOptions() {
        if (this.header) {
            this.getLocalHostname();
        }
        if (this.layout != null && this.layout.getHeader() != null) {
            this.sendLayoutMessage(this.layout.getHeader());
        }
        this.layoutHeaderChecked = true;
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setSyslogHost(String string) {
        this.sqw = new SyslogQuietWriter(new SyslogWriter(string), this.syslogFacility, this.errorHandler);
        this.syslogHost = string;
    }

    public String getSyslogHost() {
        return this.syslogHost;
    }

    public void setFacility(String string) {
        if (string == null) {
            return;
        }
        this.syslogFacility = SyslogAppender.getFacility(string);
        if (this.syslogFacility == -1) {
            System.err.println("[" + string + "] is an unknown syslog facility. Defaulting to [USER].");
            this.syslogFacility = 8;
        }
        this.initSyslogFacilityStr();
        if (this.sqw != null) {
            this.sqw.setSyslogFacility(this.syslogFacility);
        }
    }

    public String getFacility() {
        return SyslogAppender.getFacilityString(this.syslogFacility);
    }

    public void setFacilityPrinting(boolean bl) {
        this.facilityPrinting = bl;
    }

    public boolean getFacilityPrinting() {
        return this.facilityPrinting;
    }

    public final boolean getHeader() {
        return this.header;
    }

    public final void setHeader(boolean bl) {
        this.header = bl;
    }

    private String getLocalHostname() {
        if (this.localHostname == null) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                this.localHostname = inetAddress.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                this.localHostname = "UNKNOWN_HOST";
            }
        }
        return this.localHostname;
    }

    private String getPacketHeader(long l2) {
        if (this.header) {
            StringBuffer stringBuffer = new StringBuffer(this.dateFormat.format(new Date(l2)));
            if (stringBuffer.charAt(4) == '0') {
                stringBuffer.setCharAt(4, ' ');
            }
            stringBuffer.append(this.getLocalHostname());
            stringBuffer.append(' ');
            return stringBuffer.toString();
        }
        return "";
    }

    private void sendLayoutMessage(String string) {
        if (this.sqw != null) {
            String string2 = string;
            String string3 = this.getPacketHeader(new Date().getTime());
            if (this.facilityPrinting || string3.length() > 0) {
                StringBuffer stringBuffer = new StringBuffer(string3);
                if (this.facilityPrinting) {
                    stringBuffer.append(this.facilityStr);
                }
                stringBuffer.append(string);
                string2 = stringBuffer.toString();
            }
            this.sqw.setLevel(6);
            this.sqw.write(string2);
        }
    }
}

