/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.nt;

import com.contrastsecurity.thirdparty.org.apache.log4j.AppenderSkeleton;
import com.contrastsecurity.thirdparty.org.apache.log4j.Layout;
import com.contrastsecurity.thirdparty.org.apache.log4j.TTCCLayout;
import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.LogLog;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggingEvent;

public class NTEventLogAppender
extends AppenderSkeleton {
    private int _handle = 0;
    private String source = null;
    private String server = null;

    public NTEventLogAppender() {
        this(null, null, null);
    }

    public NTEventLogAppender(String string) {
        this(null, string, null);
    }

    public NTEventLogAppender(String string, String string2) {
        this(string, string2, null);
    }

    public NTEventLogAppender(Layout layout) {
        this(null, null, layout);
    }

    public NTEventLogAppender(String string, Layout layout) {
        this(null, string, layout);
    }

    public NTEventLogAppender(String string, String string2, Layout layout) {
        if (string2 == null) {
            string2 = "Log4j";
        }
        this.layout = layout == null ? new TTCCLayout() : layout;
        try {
            this._handle = this.registerEventSource(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._handle = 0;
        }
    }

    public void close() {
    }

    public void activateOptions() {
        if (this.source != null) {
            try {
                this._handle = this.registerEventSource(this.server, this.source);
            }
            catch (Exception exception) {
                LogLog.error("Could not register event source.", exception);
                this._handle = 0;
            }
        }
    }

    public void append(LoggingEvent loggingEvent) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.layout.format(loggingEvent));
        if (this.layout.ignoresThrowable() && (stringArray = loggingEvent.getThrowableStrRep()) != null) {
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(stringArray[i2]);
            }
        }
        int n3 = loggingEvent.getLevel().toInt();
        this.reportEvent(this._handle, stringBuffer.toString(), n3);
    }

    public void finalize() {
        this.deregisterEventSource(this._handle);
        this._handle = 0;
    }

    public void setSource(String string) {
        this.source = string.trim();
    }

    public String getSource() {
        return this.source;
    }

    public boolean requiresLayout() {
        return true;
    }

    private native int registerEventSource(String var1, String var2);

    private native void reportEvent(int var1, String var2, int var3);

    private native void deregisterEventSource(int var1);

    static {
        String[] stringArray;
        try {
            stringArray = new String[]{System.getProperty("os.arch")};
        }
        catch (SecurityException securityException) {
            stringArray = new String[]{"amd64", "ia64", "x86"};
        }
        boolean bl = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                System.loadLibrary("NTEventLogAppender." + stringArray[i2]);
                bl = true;
                break;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bl = false;
                continue;
            }
        }
        if (!bl) {
            System.loadLibrary("NTEventLogAppender");
        }
    }
}

