/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.pattern;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.TimeZone;

public final class CachedDateFormat
extends DateFormat {
    private static final long serialVersionUID = 1L;
    public static final int NO_MILLISECONDS = -2;
    private static final String DIGITS = "0123456789";
    public static final int UNRECOGNIZED_MILLISECONDS = -1;
    private static final int MAGIC1 = 654;
    private static final String MAGICSTRING1 = "654";
    private static final int MAGIC2 = 987;
    private static final String MAGICSTRING2 = "987";
    private static final String ZERO_STRING = "000";
    private final DateFormat formatter;
    private int millisecondStart;
    private long slotBegin;
    private StringBuffer cache = new StringBuffer(50);
    private final int expiration;
    private long previousTime;
    private final Date tmpDate = new Date(0L);

    public CachedDateFormat(DateFormat dateFormat, int n2) {
        if (dateFormat == null) {
            throw new IllegalArgumentException("dateFormat cannot be null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("expiration must be non-negative");
        }
        this.formatter = dateFormat;
        this.expiration = n2;
        this.millisecondStart = 0;
        this.previousTime = Long.MIN_VALUE;
        this.slotBegin = Long.MIN_VALUE;
    }

    public static int findMillisecondStart(long l2, String string, DateFormat dateFormat) {
        String string2;
        long l3 = l2 / 1000L * 1000L;
        if (l3 > l2) {
            l3 -= 1000L;
        }
        int n2 = (int)(l2 - l3);
        int n3 = 654;
        String string3 = MAGICSTRING1;
        if (n2 == 654) {
            n3 = 987;
            string3 = MAGICSTRING2;
        }
        if ((string2 = dateFormat.format(new Date(l3 + (long)n3))).length() != string.length()) {
            return -1;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == string2.charAt(i2)) continue;
            StringBuffer stringBuffer = new StringBuffer("ABC");
            CachedDateFormat.millisecondFormat(n2, stringBuffer, 0);
            String string4 = dateFormat.format(new Date(l3));
            if (string4.length() == string.length() && string3.regionMatches(0, string2, i2, string3.length()) && stringBuffer.toString().regionMatches(0, string, i2, string3.length()) && ZERO_STRING.regionMatches(0, string4, i2, ZERO_STRING.length())) {
                return i2;
            }
            return -1;
        }
        return -2;
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.format(date.getTime(), stringBuffer);
        return stringBuffer;
    }

    public StringBuffer format(long l2, StringBuffer stringBuffer) {
        if (l2 == this.previousTime) {
            stringBuffer.append(this.cache);
            return stringBuffer;
        }
        if (this.millisecondStart != -1 && l2 < this.slotBegin + (long)this.expiration && l2 >= this.slotBegin && l2 < this.slotBegin + 1000L) {
            if (this.millisecondStart >= 0) {
                CachedDateFormat.millisecondFormat((int)(l2 - this.slotBegin), this.cache, this.millisecondStart);
            }
            this.previousTime = l2;
            stringBuffer.append(this.cache);
            return stringBuffer;
        }
        this.cache.setLength(0);
        this.tmpDate.setTime(l2);
        this.cache.append(this.formatter.format(this.tmpDate));
        stringBuffer.append(this.cache);
        this.previousTime = l2;
        this.slotBegin = this.previousTime / 1000L * 1000L;
        if (this.slotBegin > this.previousTime) {
            this.slotBegin -= 1000L;
        }
        if (this.millisecondStart >= 0) {
            this.millisecondStart = CachedDateFormat.findMillisecondStart(l2, this.cache.toString(), this.formatter);
        }
        return stringBuffer;
    }

    private static void millisecondFormat(int n2, StringBuffer stringBuffer, int n3) {
        stringBuffer.setCharAt(n3, DIGITS.charAt(n2 / 100));
        stringBuffer.setCharAt(n3 + 1, DIGITS.charAt(n2 / 10 % 10));
        stringBuffer.setCharAt(n3 + 2, DIGITS.charAt(n2 % 10));
    }

    public void setTimeZone(TimeZone timeZone) {
        this.formatter.setTimeZone(timeZone);
        this.previousTime = Long.MIN_VALUE;
        this.slotBegin = Long.MIN_VALUE;
    }

    public Date parse(String string, ParsePosition parsePosition) {
        return this.formatter.parse(string, parsePosition);
    }

    public NumberFormat getNumberFormat() {
        return this.formatter.getNumberFormat();
    }

    public static int getMaximumCacheValidity(String string) {
        int n2 = string.indexOf(83);
        if (n2 >= 0 && n2 != string.lastIndexOf("SSS")) {
            return 1;
        }
        return 1000;
    }
}

