/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.pattern;

import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.LogLog;
import com.contrastsecurity.thirdparty.org.apache.log4j.pattern.CachedDateFormat;
import com.contrastsecurity.thirdparty.org.apache.log4j.pattern.LoggingEventPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggingEvent;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class DatePatternConverter
extends LoggingEventPatternConverter {
    private static final String ABSOLUTE_FORMAT = "ABSOLUTE";
    private static final String ABSOLUTE_TIME_PATTERN = "HH:mm:ss,SSS";
    private static final String DATE_AND_TIME_FORMAT = "DATE";
    private static final String DATE_AND_TIME_PATTERN = "dd MMM yyyy HH:mm:ss,SSS";
    private static final String ISO8601_FORMAT = "ISO8601";
    private static final String ISO8601_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    private final CachedDateFormat df;

    private DatePatternConverter(String[] stringArray) {
        super("Date", "date");
        String string = stringArray == null || stringArray.length == 0 ? null : stringArray[0];
        String string2 = string == null || string.equalsIgnoreCase(ISO8601_FORMAT) ? ISO8601_PATTERN : (string.equalsIgnoreCase(ABSOLUTE_FORMAT) ? ABSOLUTE_TIME_PATTERN : (string.equalsIgnoreCase(DATE_AND_TIME_FORMAT) ? DATE_AND_TIME_PATTERN : string));
        int n2 = 1000;
        DateFormat dateFormat = null;
        try {
            dateFormat = new SimpleDateFormat(string2);
            n2 = CachedDateFormat.getMaximumCacheValidity(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogLog.warn("Could not instantiate SimpleDateFormat with pattern " + string, illegalArgumentException);
            dateFormat = new SimpleDateFormat(ISO8601_PATTERN);
        }
        if (stringArray != null && stringArray.length > 1) {
            TimeZone timeZone = TimeZone.getTimeZone(stringArray[1]);
            dateFormat.setTimeZone(timeZone);
        } else {
            dateFormat = new DefaultZoneDateFormat(dateFormat);
        }
        this.df = new CachedDateFormat(dateFormat, n2);
    }

    public static DatePatternConverter newInstance(String[] stringArray) {
        return new DatePatternConverter(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(LoggingEvent loggingEvent, StringBuffer stringBuffer) {
        DatePatternConverter datePatternConverter = this;
        synchronized (datePatternConverter) {
            this.df.format(loggingEvent.timeStamp, stringBuffer);
        }
    }

    public void format(Object object, StringBuffer stringBuffer) {
        if (object instanceof Date) {
            this.format((Date)object, stringBuffer);
        }
        super.format(object, stringBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(Date date, StringBuffer stringBuffer) {
        DatePatternConverter datePatternConverter = this;
        synchronized (datePatternConverter) {
            this.df.format(date.getTime(), stringBuffer);
        }
    }

    private static class DefaultZoneDateFormat
    extends DateFormat {
        private static final long serialVersionUID = 1L;
        private final DateFormat dateFormat;

        public DefaultZoneDateFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            this.dateFormat.setTimeZone(TimeZone.getDefault());
            return this.dateFormat.format(date, stringBuffer, fieldPosition);
        }

        public Date parse(String string, ParsePosition parsePosition) {
            this.dateFormat.setTimeZone(TimeZone.getDefault());
            return this.dateFormat.parse(string, parsePosition);
        }
    }
}

