/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.pattern;

public final class FormattingInfo {
    private static final char[] SPACES = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private static final FormattingInfo DEFAULT = new FormattingInfo(false, 0, Integer.MAX_VALUE);
    private final int minLength;
    private final int maxLength;
    private final boolean leftAlign;

    public FormattingInfo(boolean bl, int n2, int n3) {
        this.leftAlign = bl;
        this.minLength = n2;
        this.maxLength = n3;
    }

    public static FormattingInfo getDefault() {
        return DEFAULT;
    }

    public boolean isLeftAligned() {
        return this.leftAlign;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void format(int n2, StringBuffer stringBuffer) {
        int n3 = stringBuffer.length() - n2;
        if (n3 > this.maxLength) {
            stringBuffer.delete(n2, stringBuffer.length() - this.maxLength);
        } else if (n3 < this.minLength) {
            if (this.leftAlign) {
                int n4 = stringBuffer.length();
                stringBuffer.setLength(n2 + this.minLength);
                for (int i2 = n4; i2 < stringBuffer.length(); ++i2) {
                    stringBuffer.setCharAt(i2, ' ');
                }
            } else {
                int n5;
                for (n5 = this.minLength - n3; n5 > 8; n5 -= 8) {
                    stringBuffer.insert(n2, SPACES);
                }
                stringBuffer.insert(n2, SPACES, 0, n5);
            }
        }
    }
}

