/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.pattern;

import java.util.ArrayList;
import java.util.List;

public abstract class NameAbbreviator {
    private static final NameAbbreviator DEFAULT = new NOPAbbreviator();

    public static NameAbbreviator getAbbreviator(String string) {
        if (string.length() > 0) {
            String string2 = string.trim();
            if (string2.length() == 0) {
                return DEFAULT;
            }
            int n2 = 0;
            if (string2.length() > 0) {
                if (string2.charAt(0) == '-') {
                    ++n2;
                }
                while (n2 < string2.length() && string2.charAt(n2) >= '0' && string2.charAt(n2) <= '9') {
                    ++n2;
                }
            }
            if (n2 == string2.length()) {
                int n3 = Integer.parseInt(string2);
                if (n3 >= 0) {
                    return new MaxElementAbbreviator(n3);
                }
                return new DropElementAbbreviator(-n3);
            }
            ArrayList<PatternAbbreviatorFragment> arrayList = new ArrayList<PatternAbbreviatorFragment>(5);
            for (int i2 = 0; i2 < string2.length() && i2 >= 0; ++i2) {
                int n4;
                int n5 = i2;
                if (string2.charAt(i2) == '*') {
                    n4 = Integer.MAX_VALUE;
                    ++n5;
                } else if (string2.charAt(i2) >= '0' && string2.charAt(i2) <= '9') {
                    n4 = string2.charAt(i2) - 48;
                    ++n5;
                } else {
                    n4 = 0;
                }
                char c2 = '\u0000';
                if (n5 < string2.length() && (c2 = string2.charAt(n5)) == '.') {
                    c2 = '\u0000';
                }
                arrayList.add(new PatternAbbreviatorFragment(n4, c2));
                i2 = string2.indexOf(".", i2);
                if (i2 == -1) break;
            }
            return new PatternAbbreviator(arrayList);
        }
        return DEFAULT;
    }

    public static NameAbbreviator getDefaultAbbreviator() {
        return DEFAULT;
    }

    public abstract void abbreviate(int var1, StringBuffer var2);

    private static class PatternAbbreviator
    extends NameAbbreviator {
        private final PatternAbbreviatorFragment[] fragments;

        public PatternAbbreviator(List list) {
            if (list.size() == 0) {
                throw new IllegalArgumentException("fragments must have at least one element");
            }
            this.fragments = new PatternAbbreviatorFragment[list.size()];
            list.toArray(this.fragments);
        }

        public void abbreviate(int n2, StringBuffer stringBuffer) {
            int n3 = n2;
            for (int i2 = 0; i2 < this.fragments.length - 1 && n3 < stringBuffer.length(); ++i2) {
                n3 = this.fragments[i2].abbreviate(stringBuffer, n3);
            }
            PatternAbbreviatorFragment patternAbbreviatorFragment = this.fragments[this.fragments.length - 1];
            while (n3 < stringBuffer.length() && n3 >= 0) {
                n3 = patternAbbreviatorFragment.abbreviate(stringBuffer, n3);
            }
        }
    }

    private static class PatternAbbreviatorFragment {
        private final int charCount;
        private final char ellipsis;

        public PatternAbbreviatorFragment(int n2, char c2) {
            this.charCount = n2;
            this.ellipsis = c2;
        }

        public int abbreviate(StringBuffer stringBuffer, int n2) {
            int n3 = stringBuffer.toString().indexOf(".", n2);
            if (n3 != -1) {
                if (n3 - n2 > this.charCount) {
                    stringBuffer.delete(n2 + this.charCount, n3);
                    n3 = n2 + this.charCount;
                    if (this.ellipsis != '\u0000') {
                        stringBuffer.insert(n3, this.ellipsis);
                        ++n3;
                    }
                }
                ++n3;
            }
            return n3;
        }
    }

    private static class DropElementAbbreviator
    extends NameAbbreviator {
        private final int count;

        public DropElementAbbreviator(int n2) {
            this.count = n2;
        }

        public void abbreviate(int n2, StringBuffer stringBuffer) {
            int n3 = this.count;
            int n4 = stringBuffer.indexOf(".", n2);
            while (n4 != -1) {
                if (--n3 == 0) {
                    stringBuffer.delete(n2, n4 + 1);
                    break;
                }
                n4 = stringBuffer.indexOf(".", n4 + 1);
            }
        }
    }

    private static class MaxElementAbbreviator
    extends NameAbbreviator {
        private final int count;

        public MaxElementAbbreviator(int n2) {
            this.count = n2;
        }

        public void abbreviate(int n2, StringBuffer stringBuffer) {
            int n3 = stringBuffer.length() - 1;
            String string = stringBuffer.toString();
            for (int i2 = this.count; i2 > 0; --i2) {
                if ((n3 = string.lastIndexOf(".", n3 - 1)) != -1 && n3 >= n2) continue;
                return;
            }
            stringBuffer.delete(n2, n3 + 1);
        }
    }

    private static class NOPAbbreviator
    extends NameAbbreviator {
        public void abbreviate(int n2, StringBuffer stringBuffer) {
        }
    }
}

