/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.pattern;

import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.LogLog;
import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.MDCKeySetExtractor;
import com.contrastsecurity.thirdparty.org.apache.log4j.pattern.LoggingEventPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggingEvent;
import java.util.Iterator;
import java.util.Set;

public final class PropertiesPatternConverter
extends LoggingEventPatternConverter {
    private final String option;

    private PropertiesPatternConverter(String[] stringArray) {
        super(stringArray != null && stringArray.length > 0 ? "Property{" + stringArray[0] + "}" : "Properties", "property");
        this.option = stringArray != null && stringArray.length > 0 ? stringArray[0] : null;
    }

    public static PropertiesPatternConverter newInstance(String[] stringArray) {
        return new PropertiesPatternConverter(stringArray);
    }

    public void format(LoggingEvent loggingEvent, StringBuffer stringBuffer) {
        if (this.option == null) {
            stringBuffer.append("{");
            try {
                Set set = MDCKeySetExtractor.INSTANCE.getPropertyKeySet(loggingEvent);
                if (set != null) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Object e2 = iterator.next();
                        Object object = loggingEvent.getMDC(e2.toString());
                        stringBuffer.append("{").append(e2).append(",").append(object).append("}");
                    }
                }
            }
            catch (Exception exception) {
                LogLog.error("Unexpected exception while extracting MDC keys", exception);
            }
            stringBuffer.append("}");
        } else {
            Object object = loggingEvent.getMDC(this.option);
            if (object != null) {
                stringBuffer.append(object);
            }
        }
    }
}

