/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.pattern;

import com.contrastsecurity.thirdparty.org.apache.log4j.pattern.LoggingEventPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggingEvent;

public class RelativeTimePatternConverter
extends LoggingEventPatternConverter {
    private CachedTimestamp lastTimestamp = new CachedTimestamp(0L, "");

    public RelativeTimePatternConverter() {
        super("Time", "time");
    }

    public static RelativeTimePatternConverter newInstance(String[] stringArray) {
        return new RelativeTimePatternConverter();
    }

    public void format(LoggingEvent loggingEvent, StringBuffer stringBuffer) {
        long l2 = loggingEvent.timeStamp;
        if (!this.lastTimestamp.format(l2, stringBuffer)) {
            String string = Long.toString(l2 - LoggingEvent.getStartTime());
            stringBuffer.append(string);
            this.lastTimestamp = new CachedTimestamp(l2, string);
        }
    }

    private static final class CachedTimestamp {
        private final long timestamp;
        private final String formatted;

        public CachedTimestamp(long l2, String string) {
            this.timestamp = l2;
            this.formatted = string;
        }

        public boolean format(long l2, StringBuffer stringBuffer) {
            if (l2 == this.timestamp) {
                stringBuffer.append(this.formatted);
                return true;
            }
            return false;
        }
    }
}

