/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.pattern;

import com.contrastsecurity.thirdparty.org.apache.log4j.pattern.LoggingEventPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.LoggingEvent;
import com.contrastsecurity.thirdparty.org.apache.log4j.spi.ThrowableInformation;

public class ThrowableInformationPatternConverter
extends LoggingEventPatternConverter {
    private int maxLines = Integer.MAX_VALUE;

    private ThrowableInformationPatternConverter(String[] stringArray) {
        super("Throwable", "throwable");
        if (stringArray != null && stringArray.length > 0) {
            if ("none".equals(stringArray[0])) {
                this.maxLines = 0;
            } else if ("short".equals(stringArray[0])) {
                this.maxLines = 1;
            } else {
                try {
                    this.maxLines = Integer.parseInt(stringArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public static ThrowableInformationPatternConverter newInstance(String[] stringArray) {
        return new ThrowableInformationPatternConverter(stringArray);
    }

    public void format(LoggingEvent loggingEvent, StringBuffer stringBuffer) {
        ThrowableInformation throwableInformation;
        if (this.maxLines != 0 && (throwableInformation = loggingEvent.getThrowableInformation()) != null) {
            String[] stringArray = throwableInformation.getThrowableStrRep();
            int n2 = stringArray.length;
            if (this.maxLines < 0) {
                n2 += this.maxLines;
            } else if (n2 > this.maxLines) {
                n2 = this.maxLines;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray[i2];
                stringBuffer.append(string).append("\n");
            }
        }
    }

    public boolean handlesThrowable() {
        return true;
    }
}

