/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.log4j.spi;

import com.contrastsecurity.thirdparty.org.apache.log4j.Layout;
import com.contrastsecurity.thirdparty.org.apache.log4j.helpers.LogLog;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LocationInfo
implements Serializable {
    transient String lineNumber;
    transient String fileName;
    transient String className;
    transient String methodName;
    public String fullInfo;
    private static StringWriter sw = new StringWriter();
    private static PrintWriter pw = new PrintWriter(sw);
    private static Method getStackTraceMethod;
    private static Method getClassNameMethod;
    private static Method getMethodNameMethod;
    private static Method getFileNameMethod;
    private static Method getLineNumberMethod;
    public static final String NA = "?";
    static final long serialVersionUID = -1325822038990805636L;
    public static final LocationInfo NA_LOCATION_INFO;
    static boolean inVisualAge;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocationInfo(Throwable throwable, String string) {
        int n2;
        String string2;
        if (throwable == null || string == null) {
            return;
        }
        if (getLineNumberMethod != null) {
            try {
                Object[] objectArray = null;
                Object[] objectArray2 = (Object[])getStackTraceMethod.invoke((Object)throwable, objectArray);
                String string3 = NA;
                for (int i2 = objectArray2.length - 1; i2 >= 0; --i2) {
                    String string4 = (String)getClassNameMethod.invoke(objectArray2[i2], objectArray);
                    if (string.equals(string4)) {
                        int n3 = i2 + 1;
                        if (n3 < objectArray2.length) {
                            int n4;
                            this.className = string3;
                            this.methodName = (String)getMethodNameMethod.invoke(objectArray2[n3], objectArray);
                            this.fileName = (String)getFileNameMethod.invoke(objectArray2[n3], objectArray);
                            if (this.fileName == null) {
                                this.fileName = NA;
                            }
                            this.lineNumber = (n4 = ((Integer)getLineNumberMethod.invoke(objectArray2[n3], objectArray)).intValue()) < 0 ? NA : String.valueOf(n4);
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(this.className);
                            stringBuffer.append(".");
                            stringBuffer.append(this.methodName);
                            stringBuffer.append("(");
                            stringBuffer.append(this.fileName);
                            stringBuffer.append(":");
                            stringBuffer.append(this.lineNumber);
                            stringBuffer.append(")");
                            this.fullInfo = stringBuffer.toString();
                        }
                        return;
                    }
                    string3 = string4;
                }
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                LogLog.debug("LocationInfo failed using JDK 1.4 methods", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof InterruptedException || invocationTargetException.getTargetException() instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.debug("LocationInfo failed using JDK 1.4 methods", invocationTargetException);
            }
            catch (RuntimeException runtimeException) {
                LogLog.debug("LocationInfo failed using JDK 1.4 methods", runtimeException);
            }
        }
        StringWriter stringWriter = sw;
        synchronized (stringWriter) {
            throwable.printStackTrace(pw);
            string2 = sw.toString();
            sw.getBuffer().setLength(0);
        }
        int n5 = string2.lastIndexOf(string);
        if (n5 == -1) {
            return;
        }
        if (n5 + string.length() < string2.length() && string2.charAt(n5 + string.length()) != '.' && (n2 = string2.lastIndexOf(string + ".")) != -1) {
            n5 = n2;
        }
        if ((n5 = string2.indexOf(Layout.LINE_SEP, n5)) == -1) {
            return;
        }
        int n6 = string2.indexOf(Layout.LINE_SEP, n5 += Layout.LINE_SEP_LEN);
        if (n6 == -1) {
            return;
        }
        if (!inVisualAge) {
            n5 = string2.lastIndexOf("at ", n6);
            if (n5 == -1) {
                return;
            }
            n5 += 3;
        }
        this.fullInfo = string2.substring(n5, n6);
    }

    private static final void appendFragment(StringBuffer stringBuffer, String string) {
        if (string == null) {
            stringBuffer.append(NA);
        } else {
            stringBuffer.append(string);
        }
    }

    public LocationInfo(String string, String string2, String string3, String string4) {
        this.fileName = string;
        this.className = string2;
        this.methodName = string3;
        this.lineNumber = string4;
        StringBuffer stringBuffer = new StringBuffer();
        LocationInfo.appendFragment(stringBuffer, string2);
        stringBuffer.append(".");
        LocationInfo.appendFragment(stringBuffer, string3);
        stringBuffer.append("(");
        LocationInfo.appendFragment(stringBuffer, string);
        stringBuffer.append(":");
        LocationInfo.appendFragment(stringBuffer, string4);
        stringBuffer.append(")");
        this.fullInfo = stringBuffer.toString();
    }

    public String getClassName() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.className == null) {
            int n2 = this.fullInfo.lastIndexOf(40);
            if (n2 == -1) {
                this.className = NA;
            } else {
                n2 = this.fullInfo.lastIndexOf(46, n2);
                int n3 = 0;
                if (inVisualAge) {
                    n3 = this.fullInfo.lastIndexOf(32, n2) + 1;
                }
                this.className = n2 == -1 ? NA : this.fullInfo.substring(n3, n2);
            }
        }
        return this.className;
    }

    public String getFileName() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.fileName == null) {
            int n2 = this.fullInfo.lastIndexOf(58);
            if (n2 == -1) {
                this.fileName = NA;
            } else {
                int n3 = this.fullInfo.lastIndexOf(40, n2 - 1);
                this.fileName = this.fullInfo.substring(n3 + 1, n2);
            }
        }
        return this.fileName;
    }

    public String getLineNumber() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.lineNumber == null) {
            int n2 = this.fullInfo.lastIndexOf(41);
            int n3 = this.fullInfo.lastIndexOf(58, n2 - 1);
            this.lineNumber = n3 == -1 ? NA : this.fullInfo.substring(n3 + 1, n2);
        }
        return this.lineNumber;
    }

    public String getMethodName() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.methodName == null) {
            int n2 = this.fullInfo.lastIndexOf(40);
            int n3 = this.fullInfo.lastIndexOf(46, n2);
            this.methodName = n3 == -1 ? NA : this.fullInfo.substring(n3 + 1, n2);
        }
        return this.methodName;
    }

    static {
        NA_LOCATION_INFO = new LocationInfo(NA, NA, NA, NA);
        inVisualAge = false;
        try {
            inVisualAge = Class.forName("com.ibm.uvm.tools.DebugSupport") != null;
            LogLog.debug("Detected IBM VisualAge environment.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class<?>[] classArray = null;
            getStackTraceMethod = Throwable.class.getMethod("getStackTrace", classArray);
            Class<?> clazz = Class.forName("java.lang.StackTraceElement");
            getClassNameMethod = clazz.getMethod("getClassName", classArray);
            getMethodNameMethod = clazz.getMethod("getMethodName", classArray);
            getFileNameMethod = clazz.getMethod("getFileName", classArray);
            getLineNumberMethod = clazz.getMethod("getLineNumber", classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogLog.debug("LocationInfo will use pre-JDK 1.4 methods to determine location.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LogLog.debug("LocationInfo will use pre-JDK 1.4 methods to determine location.");
        }
    }
}

